/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri.updater;

import java.util.List;
import java.util.function.Consumer;
import org.apache.commons.lang3.BooleanUtils;
import org.opentripplanner.ext.siri.SiriFuzzyTripMatcher;
import org.opentripplanner.ext.siri.SiriTimetableSnapshotSource;
import org.opentripplanner.ext.siri.updater.EstimatedTimetableSource;
import org.opentripplanner.ext.siri.updater.SiriETHttpTripUpdateSource;
import org.opentripplanner.ext.siri.updater.SiriETUpdaterParameters;
import org.opentripplanner.transit.service.DefaultTransitService;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.opentripplanner.updater.trip.UpdateResult;
import org.opentripplanner.updater.trip.metrics.TripUpdateMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.ServiceDelivery;
import uk.org.siri.siri20.Siri;

public class SiriETUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(SiriETUpdater.class);
    private final EstimatedTimetableSource updateSource;
    private final String feedId;
    protected WriteToGraphCallback saveResultOnGraph;
    private final SiriTimetableSnapshotSource snapshotSource;
    private final SiriFuzzyTripMatcher fuzzyTripMatcher;
    private final Consumer<UpdateResult> recordMetrics;

    public SiriETUpdater(SiriETUpdaterParameters config, TransitModel transitModel, SiriTimetableSnapshotSource timetableSnapshot) {
        super(config);
        this.feedId = config.getFeedId();
        this.updateSource = new SiriETHttpTripUpdateSource(config.sourceParameters());
        this.snapshotSource = timetableSnapshot;
        this.blockReadinessUntilInitialized = config.blockReadinessUntilInitialized();
        this.fuzzyTripMatcher = config.isFuzzyTripMatching() ? SiriFuzzyTripMatcher.of(new DefaultTransitService(transitModel)) : null;
        LOG.info("Creating stop time updater (SIRI ET) running every {} seconds : {}", (Object)this.pollingPeriodSeconds(), (Object)this.updateSource);
        this.recordMetrics = TripUpdateMetrics.streaming(config);
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void runPolling() {
        boolean moreData = false;
        do {
            Siri updates;
            if ((updates = this.updateSource.getUpdates()) == null) continue;
            boolean fullDataset = this.updateSource.getFullDatasetValueOfLastUpdates();
            ServiceDelivery serviceDelivery = updates.getServiceDelivery();
            moreData = BooleanUtils.isTrue((Boolean)serviceDelivery.isMoreData());
            boolean markPrimed = !moreData;
            List etds = serviceDelivery.getEstimatedTimetableDeliveries();
            if (etds == null) continue;
            this.saveResultOnGraph.execute((graph, transitModel) -> {
                UpdateResult result = this.snapshotSource.applyEstimatedTimetable(transitModel, this.fuzzyTripMatcher, this.feedId, fullDataset, etds);
                this.recordMetrics.accept(result);
                if (markPrimed) {
                    this.primed = true;
                }
            });
        } while (moreData);
    }

    public String toString() {
        String s = this.updateSource == null ? "NONE" : this.updateSource.toString();
        return "Polling SIRI ET updater with update source = " + s;
    }
}

