/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.siri;

import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opentripplanner.transit.model.basic.SubMode;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripOnServiceDate;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.util.time.ServiceDateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.siri.siri20.EstimatedCall;
import uk.org.siri.siri20.EstimatedVehicleJourney;
import uk.org.siri.siri20.MonitoredVehicleJourneyStructure;
import uk.org.siri.siri20.RecordedCall;
import uk.org.siri.siri20.VehicleModesEnumeration;

public class SiriFuzzyTripMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(SiriFuzzyTripMatcher.class);
    private static SiriFuzzyTripMatcher instance;
    private final Map<String, Set<Trip>> internalPlanningCodeCache = new HashMap<String, Set<Trip>>();
    private final Map<String, Set<Trip>> startStopTripCache = new HashMap<String, Set<Trip>>();
    private final TransitService transitService;
    private boolean initialized = false;

    public static SiriFuzzyTripMatcher of(TransitService transitService) {
        if (instance == null) {
            instance = new SiriFuzzyTripMatcher(transitService);
        }
        return instance;
    }

    private SiriFuzzyTripMatcher(TransitService transitService) {
        this.transitService = transitService;
        this.initCache(this.transitService);
    }

    public Set<Trip> match(MonitoredVehicleJourneyStructure monitoredVehicleJourney, String feedId) {
        if (monitoredVehicleJourney != null) {
            Trip trip;
            String datedVehicleRef;
            if (monitoredVehicleJourney.getFramedVehicleJourneyRef() != null && (datedVehicleRef = monitoredVehicleJourney.getFramedVehicleJourneyRef().getDatedVehicleJourneyRef()) != null && (trip = this.transitService.getTripForId(new FeedScopedId(feedId, datedVehicleRef))) != null) {
                return Set.of(trip);
            }
            if (monitoredVehicleJourney.getDestinationRef() != null) {
                String destinationRef = monitoredVehicleJourney.getDestinationRef().getValue();
                ZonedDateTime arrivalTime = monitoredVehicleJourney.getDestinationAimedArrivalTime();
                if (arrivalTime != null) {
                    return this.getMatchingTripsOnStopOrSiblings(destinationRef, feedId, arrivalTime);
                }
            }
        }
        return Set.of();
    }

    public Set<Trip> match(EstimatedVehicleJourney journey, String feedId) {
        Trip trip;
        String serviceJourneyId;
        Set<Trip> trips = null;
        if (journey.getVehicleRef() != null && journey.getVehicleModes() != null && journey.getVehicleModes().contains(VehicleModesEnumeration.RAIL)) {
            trips = this.getCachedTripsByInternalPlanningCode(journey.getVehicleRef().getValue());
        }
        if ((trips == null || trips.isEmpty()) && (serviceJourneyId = SiriFuzzyTripMatcher.resolveDatedVehicleJourneyRef(journey)) != null && (trip = this.transitService.getTripForId(new FeedScopedId(feedId, serviceJourneyId))) != null) {
            trips = Set.of(trip);
        }
        if (trips == null || trips.isEmpty()) {
            String lastStopPoint = null;
            ZonedDateTime arrivalTime = null;
            if (journey.getEstimatedCalls() != null && journey.getEstimatedCalls().getEstimatedCalls() != null && !journey.getEstimatedCalls().getEstimatedCalls().isEmpty()) {
                List estimatedCalls = journey.getEstimatedCalls().getEstimatedCalls();
                EstimatedCall lastStop = (EstimatedCall)estimatedCalls.get(estimatedCalls.size() - 1);
                lastStopPoint = lastStop.getStopPointRef().getValue();
                arrivalTime = lastStop.getAimedArrivalTime() != null ? lastStop.getAimedArrivalTime() : lastStop.getAimedDepartureTime();
            } else if (journey.getRecordedCalls() != null && journey.getRecordedCalls().getRecordedCalls() != null && !journey.getRecordedCalls().getRecordedCalls().isEmpty()) {
                List recordedCalls = journey.getRecordedCalls().getRecordedCalls();
                RecordedCall lastStop = (RecordedCall)recordedCalls.get(recordedCalls.size() - 1);
                lastStopPoint = lastStop.getStopPointRef().getValue();
                ZonedDateTime zonedDateTime = arrivalTime = lastStop.getAimedArrivalTime() != null ? lastStop.getAimedArrivalTime() : lastStop.getAimedDepartureTime();
            }
            if (arrivalTime != null) {
                trips = this.getMatchingTripsOnStopOrSiblings(lastStopPoint, feedId, arrivalTime);
            }
        }
        return trips;
    }

    public List<FeedScopedId> getTripIdForInternalPlanningCodeServiceDateAndMode(String internalPlanningCode, LocalDate serviceDate, TransitMode mode, SubMode transportSubmode) {
        Set<Trip> cachedTripsBySiriId = this.getCachedTripsByInternalPlanningCode(internalPlanningCode);
        ArrayList<FeedScopedId> matches = new ArrayList<FeedScopedId>();
        for (Trip trip : cachedTripsBySiriId) {
            Set<LocalDate> serviceDates;
            TripPattern tripPattern = this.transitService.getPatternForTrip(trip);
            if (!tripPattern.matchesModeOrSubMode(mode, transportSubmode) || !(serviceDates = this.transitService.getCalendarService().getServiceDatesForServiceId(trip.getServiceId())).contains(serviceDate) || trip.getNetexInternalPlanningCode() == null || !trip.getNetexInternalPlanningCode().equals(internalPlanningCode)) continue;
            matches.add(trip.getId());
        }
        return matches;
    }

    static Trip findTripByDatedVehicleJourneyRef(EstimatedVehicleJourney journey, String feedId, TransitService transitService) {
        String serviceJourneyId = SiriFuzzyTripMatcher.resolveDatedVehicleJourneyRef(journey);
        if (serviceJourneyId != null) {
            Trip trip = transitService.getTripForId(new FeedScopedId(feedId, serviceJourneyId));
            if (trip != null) {
                return trip;
            }
            TripOnServiceDate tripOnServiceDate = transitService.getTripOnServiceDateById(new FeedScopedId(feedId, serviceJourneyId));
            if (tripOnServiceDate != null) {
                return tripOnServiceDate.getTrip();
            }
        }
        return null;
    }

    private void initCache(TransitService index) {
        if (!this.initialized) {
            for (Trip trip : index.getAllTrips()) {
                TripPattern tripPattern = index.getPatternForTrip(trip);
                if (tripPattern == null) continue;
                if (tripPattern.matchesModeOrSubMode(TransitMode.RAIL, SubMode.of("railReplacementBus")) && trip.getNetexInternalPlanningCode() != null) {
                    String internalPlanningCode = trip.getNetexInternalPlanningCode();
                    if (this.internalPlanningCodeCache.containsKey(internalPlanningCode)) {
                        this.internalPlanningCodeCache.get(internalPlanningCode).add(trip);
                    } else {
                        HashSet<Trip> initialSet = new HashSet<Trip>();
                        initialSet.add(trip);
                        this.internalPlanningCodeCache.put(internalPlanningCode, initialSet);
                    }
                }
                String lastStopId = tripPattern.lastStop().getId().getId();
                TripTimes tripTimes = tripPattern.getScheduledTimetable().getTripTimes(trip);
                if (tripTimes == null) continue;
                int arrivalTime = tripTimes.getArrivalTime(tripTimes.getNumStops() - 1);
                String key = SiriFuzzyTripMatcher.createStartStopKey(lastStopId, arrivalTime);
                if (this.startStopTripCache.containsKey(key)) {
                    this.startStopTripCache.get(key).add(trip);
                    continue;
                }
                HashSet<Trip> initialSet = new HashSet<Trip>();
                initialSet.add(trip);
                this.startStopTripCache.put(key, initialSet);
            }
            LOG.info("Built internalPlanningCode-cache [{}].", (Object)this.internalPlanningCodeCache.size());
            LOG.info("Built start-stop-cache [{}].", (Object)this.startStopTripCache.size());
        }
        this.initialized = true;
    }

    private static String createStartStopKey(String lastStopId, int lastStopArrivalTime) {
        return lastStopId + ":" + lastStopArrivalTime;
    }

    private static String resolveDatedVehicleJourneyRef(EstimatedVehicleJourney journey) {
        if (journey.getFramedVehicleJourneyRef() != null) {
            return journey.getFramedVehicleJourneyRef().getDatedVehicleJourneyRef();
        }
        if (journey.getDatedVehicleJourneyRef() != null) {
            return journey.getDatedVehicleJourneyRef().getValue();
        }
        return null;
    }

    private Set<Trip> getMatchingTripsOnStopOrSiblings(String lastStopPoint, String feedId, ZonedDateTime arrivalTime) {
        RegularStop stop;
        int secondsSinceMidnight = ServiceDateUtils.secondsSinceStartOfService(arrivalTime, arrivalTime, this.transitService.getTimeZone());
        int secondsSinceMidnightYesterday = ServiceDateUtils.secondsSinceStartOfService(arrivalTime.minusDays(1L), arrivalTime, this.transitService.getTimeZone());
        Set<Trip> trips = this.startStopTripCache.get(SiriFuzzyTripMatcher.createStartStopKey(lastStopPoint, secondsSinceMidnight));
        if (trips == null) {
            trips = this.startStopTripCache.get(SiriFuzzyTripMatcher.createStartStopKey(lastStopPoint, secondsSinceMidnightYesterday));
        }
        if ((trips == null || trips.isEmpty()) && (stop = this.transitService.getRegularStop(new FeedScopedId(feedId, lastStopPoint))) != null && stop.isPartOfStation()) {
            Collection<StopLocation> allQuays = stop.getParentStation().getChildStops();
            for (StopLocation quay : allQuays) {
                Set<Trip> tripSet = this.startStopTripCache.get(SiriFuzzyTripMatcher.createStartStopKey(quay.getId().getId(), secondsSinceMidnight));
                if (tripSet == null) continue;
                if (trips == null) {
                    trips = tripSet;
                    continue;
                }
                trips.addAll(tripSet);
            }
        }
        return trips;
    }

    private Set<Trip> getCachedTripsByInternalPlanningCode(String vehicleRef) {
        if (vehicleRef == null) {
            return null;
        }
        return this.internalPlanningCodeCache.getOrDefault(vehicleRef, new HashSet());
    }
}

