/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.reportapi.resource;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opentripplanner.common.model.CachedValue;
import org.opentripplanner.ext.reportapi.model.BicycleSafetyReport;
import org.opentripplanner.ext.reportapi.model.GraphReportBuilder;
import org.opentripplanner.ext.reportapi.model.TransfersReport;
import org.opentripplanner.graph_builder.module.osm.tagmapping.OsmTagMapper;
import org.opentripplanner.model.transfer.TransferService;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.transit.service.TransitService;

@Path(value="/report")
@Produces(value={"text/plain"})
public class ReportResource {
    private static final CachedValue<GraphReportBuilder.GraphStats> cachedStats = new CachedValue(Duration.ofMinutes(5L));
    private final TransferService transferService;
    private final TransitService transitService;

    public ReportResource(@Context OtpServerRequestContext requestContext) {
        this.transferService = requestContext.transitService().getTransferService();
        this.transitService = requestContext.transitService();
    }

    @GET
    @Path(value="/transfers.csv")
    @Produces(value={"application/octet-stream"})
    public String getTransfersAsCsv() {
        return TransfersReport.export(this.transferService.listAll(), this.transitService);
    }

    @GET
    @Path(value="/bicycle-safety.html")
    @Produces(value={"text/html"})
    public Response getBicycleSafetyPage() {
        InputStream is = this.getClass().getResourceAsStream("/reportapi/report.html");
        try {
            return Response.ok((Object)new String(is.readAllBytes(), StandardCharsets.UTF_8)).build();
        }
        catch (IOException e) {
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="/bicycle-safety.csv")
    @Produces(value={"text/csv"})
    public Response getBicycleSafetyAsCsv(@DefaultValue(value="default") @QueryParam(value="osmWayPropertySet") String osmWayPropertySet) {
        OsmTagMapper.Source source = OsmTagMapper.Source.valueOf(osmWayPropertySet);
        return Response.ok((Object)BicycleSafetyReport.makeCsv(source)).header("Content-Disposition", (Object)("attachment; filename=\"" + osmWayPropertySet + "-bicycle-safety.csv\"")).build();
    }

    @GET
    @Path(value="/graph.json")
    public Response stats(@Context OtpServerRequestContext serverRequestContext) {
        return Response.status((Response.Status)Response.Status.OK).entity((Object)cachedStats.get(() -> GraphReportBuilder.build(serverRequestContext))).type("application/json").build();
    }
}

