/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.reportapi.model;

import org.opentripplanner.util.time.DurationUtils;
import org.opentripplanner.util.time.TimeUtils;

class CsvReportBuilder {
    public static final char NEW_LINE = '\n';
    private final String sep;
    private final StringBuilder buf = new StringBuilder();

    CsvReportBuilder() {
        this(";");
    }

    CsvReportBuilder(String separator) {
        this.sep = separator;
    }

    public String toString() {
        return this.buf.toString();
    }

    void addEnum(Enum<?> enumValue) {
        this.buf.append(enumValue);
        this.sep();
    }

    void addDuration(int duration, int notSet) {
        this.buf.append(DurationUtils.durationToStr(duration, notSet));
        this.sep();
    }

    void addTime(int time, int notSet) {
        this.buf.append(TimeUtils.timeToStrLong(time, notSet));
        this.sep();
    }

    void addHeader(String ... headers) {
        for (String it : headers) {
            this.addText(it);
        }
        this.newLine();
    }

    void addText(String text) {
        this.buf.append(text);
        this.sep();
    }

    void addNumber(Number num) {
        this.buf.append(num == null ? "" : num.toString());
        this.sep();
    }

    void addBoolean(Boolean b) {
        this.buf.append(b == null ? "" : b.toString());
        this.sep();
    }

    void addOptText(boolean addIt, String text) {
        if (addIt) {
            this.buf.append(text);
        }
        this.sep();
    }

    void sep() {
        this.buf.append(this.sep);
    }

    void newLine() {
        this.buf.append('\n');
    }
}

