/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLUtils;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.transit.model.timetable.RealTimeState;
import org.opentripplanner.transit.model.timetable.Trip;

public class LegacyGraphQLStoptimeImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLStoptime {
    @Override
    public DataFetcher<Integer> arrivalDelay() {
        return environment -> this.missingValueToNull(this.getSource(environment).getArrivalDelay());
    }

    @Override
    public DataFetcher<Integer> departureDelay() {
        return environment -> this.getSource(environment).getDepartureDelay();
    }

    @Override
    public DataFetcher<String> dropoffType() {
        return environment -> switch (this.getSource(environment).getDropoffType()) {
            default -> throw new IncompatibleClassChangeError();
            case PickDrop.SCHEDULED -> "SCHEDULED";
            case PickDrop.NONE -> "NONE";
            case PickDrop.CALL_AGENCY -> "CALL_AGENCY";
            case PickDrop.COORDINATE_WITH_DRIVER -> "COORDINATE_WITH_DRIVER";
            case PickDrop.CANCELLED -> null;
        };
    }

    @Override
    public DataFetcher<String> headsign() {
        return environment -> LegacyGraphQLUtils.getTranslation(this.getSource(environment).getHeadsign(), environment);
    }

    @Override
    public DataFetcher<String> pickupType() {
        return environment -> switch (this.getSource(environment).getPickupType()) {
            default -> throw new IncompatibleClassChangeError();
            case PickDrop.SCHEDULED -> "SCHEDULED";
            case PickDrop.NONE -> "NONE";
            case PickDrop.CALL_AGENCY -> "CALL_AGENCY";
            case PickDrop.COORDINATE_WITH_DRIVER -> "COORDINATE_WITH_DRIVER";
            case PickDrop.CANCELLED -> null;
        };
    }

    @Override
    public DataFetcher<Boolean> realtime() {
        return environment -> this.getSource(environment).isRealtime();
    }

    @Override
    public DataFetcher<Integer> realtimeArrival() {
        return environment -> this.missingValueToNull(this.getSource(environment).getRealtimeArrival());
    }

    @Override
    public DataFetcher<Integer> realtimeDeparture() {
        return environment -> this.missingValueToNull(this.getSource(environment).getRealtimeDeparture());
    }

    @Override
    public DataFetcher<String> realtimeState() {
        return environment -> this.getSource(environment).isCanceledEffectively() ? RealTimeState.CANCELED.name() : this.getSource(environment).getRealtimeState().name();
    }

    @Override
    public DataFetcher<Integer> scheduledArrival() {
        return environment -> this.missingValueToNull(this.getSource(environment).getScheduledArrival());
    }

    @Override
    public DataFetcher<Integer> scheduledDeparture() {
        return environment -> this.missingValueToNull(this.getSource(environment).getScheduledDeparture());
    }

    @Override
    public DataFetcher<Long> serviceDay() {
        return environment -> this.getSource(environment).getServiceDayMidnight();
    }

    @Override
    public DataFetcher<Object> stop() {
        return environment -> this.getSource(environment).getStop();
    }

    @Override
    public DataFetcher<Boolean> timepoint() {
        return environment -> this.getSource(environment).isTimepoint();
    }

    @Override
    public DataFetcher<Trip> trip() {
        return environment -> this.getSource(environment).getTrip();
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private TripTimeOnDate getSource(DataFetchingEnvironment environment) {
        return (TripTimeOnDate)environment.getSource();
    }

    private Integer missingValueToNull(int value) {
        if (value == -999) {
            return null;
        }
        return value;
    }
}

