/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import graphql.execution.DataFetcherResult;
import graphql.relay.Connection;
import graphql.relay.Relay;
import graphql.relay.SimpleListConnection;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.DataFetchingEnvironmentImpl;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opentripplanner.api.common.LocationStringParser;
import org.opentripplanner.api.parameter.QualifiedMode;
import org.opentripplanner.api.parameter.QualifiedModeSet;
import org.opentripplanner.ext.fares.impl.DefaultFareService;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLUtils;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLCauseMapper;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLEffectMapper;
import org.opentripplanner.ext.legacygraphqlapi.mapping.LegacyGraphQLSeverityMapper;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.gtfs.mapping.DirectionMapper;
import org.opentripplanner.model.GenericLocation;
import org.opentripplanner.model.TripTimeOnDate;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.framework.RequestFunctions;
import org.opentripplanner.routing.api.request.request.VehicleRentalRequest;
import org.opentripplanner.routing.api.response.RoutingResponse;
import org.opentripplanner.routing.core.BicycleOptimizeType;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.error.RoutingValidationException;
import org.opentripplanner.routing.fares.FareService;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.graphfinder.PatternAtStop;
import org.opentripplanner.routing.graphfinder.PlaceAtDistance;
import org.opentripplanner.routing.graphfinder.PlaceType;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_parking.VehicleParkingService;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStation;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationService;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalVehicle;
import org.opentripplanner.transit.model.basic.TransitMode;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.Station;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.updater.GtfsRealtimeFuzzyTripMatcher;
import org.opentripplanner.util.time.ServiceDateUtils;

public class LegacyGraphQLQueryTypeImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLQueryType {
    private static final DirectionMapper DIRECTION_MAPPER = new DirectionMapper(DataImportIssueStore.noopIssueStore());

    public static <T> boolean hasArgument(Map<String, T> m, String name) {
        return m.containsKey(name) && m.get(name) != null;
    }

    @Override
    public DataFetcher<Iterable<Agency>> agencies() {
        return environment -> this.getTransitService(environment).getAgencies();
    }

    @Override
    public DataFetcher<Agency> agency() {
        return environment -> {
            FeedScopedId id = FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypeAgencyArgs(environment.getArguments()).getLegacyGraphQLId());
            return this.getTransitService(environment).getAgencyForId(id);
        };
    }

    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            Collection<TransitAlert> alerts = this.getTransitService(environment).getTransitAlertService().getAllAlerts();
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeAlertsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeAlertsArgs(environment.getArguments());
            List severities = args.getLegacyGraphQLSeverityLevel() == null ? null : ((List)args.getLegacyGraphQLSeverityLevel()).stream().map(severity -> severity.name()).collect(Collectors.toList());
            List effects = args.getLegacyGraphQLEffect() == null ? null : ((List)args.getLegacyGraphQLEffect()).stream().map(effect -> effect.name()).collect(Collectors.toList());
            List causes = args.getLegacyGraphQLCause() == null ? null : ((List)args.getLegacyGraphQLCause()).stream().map(cause -> cause.name()).collect(Collectors.toList());
            return alerts.stream().filter(alert -> args.getLegacyGraphQLFeeds() == null || ((List)args.getLegacyGraphQLFeeds()).contains(alert.getFeedId())).filter(alert -> args.getLegacyGraphQLSeverityLevel() == null || severities.contains(LegacyGraphQLSeverityMapper.getLegacyGraphQLSeverity(alert.severity))).filter(alert -> args.getLegacyGraphQLEffect() == null || effects.contains(LegacyGraphQLEffectMapper.getLegacyGraphQLEffect(alert.effect))).filter(alert -> args.getLegacyGraphQLCause() == null || causes.contains(LegacyGraphQLCauseMapper.getLegacyGraphQLCause(alert.cause))).filter(alert -> {
                if (args.getLegacyGraphQLRoute() == null) return true;
                if (!alert.getEntities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.Route).map(EntitySelector.Route.class::cast).anyMatch(route -> ((List)args.getLegacyGraphQLRoute()).contains(route.routeId.toString()))) return false;
                return true;
            }).filter(alert -> {
                if (args.getLegacyGraphQLStop() == null) return true;
                if (!alert.getEntities().stream().filter(entitySelector -> entitySelector instanceof EntitySelector.Stop).map(EntitySelector.Stop.class::cast).anyMatch(stop -> ((List)args.getLegacyGraphQLStop()).contains(stop.stopId.toString()))) return false;
                return true;
            }).collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<VehicleParking> bikePark() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeParkArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeParkArgs(environment.getArguments());
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            return vehicleParkingService.getBikeParks().filter(bikePark -> bikePark.getId().getId().equals(args.getLegacyGraphQLId())).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Iterable<VehicleParking>> bikeParks() {
        return environment -> {
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            return vehicleParkingService.getBikeParks().collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<VehicleRentalPlace> bikeRentalStation() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeRentalStationArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeRentalStationArgs(environment.getArguments());
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            return vehicleRentalStationService.getVehicleRentalPlaces().stream().filter(vehicleRentalStation -> vehicleRentalStation.getStationId().equals(args.getLegacyGraphQLId())).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Iterable<VehicleRentalPlace>> bikeRentalStations() {
        return environment -> {
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeRentalStationsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeBikeRentalStationsArgs(environment.getArguments());
            if (args.getLegacyGraphQLIds() != null) {
                ArrayListMultimap vehicleRentalStations = (ArrayListMultimap)vehicleRentalStationService.getVehicleRentalPlaces().stream().collect(Multimaps.toMultimap(VehicleRentalPlace::getStationId, station -> station, ArrayListMultimap::create));
                return ((List)args.getLegacyGraphQLIds()).stream().flatMap(id -> vehicleRentalStations.get(id).stream()).collect(Collectors.toList());
            }
            return vehicleRentalStationService.getVehicleRentalPlaces();
        };
    }

    @Override
    public DataFetcher<Iterable<TripTimeOnDate>> cancelledTripTimes() {
        return environment -> null;
    }

    @Override
    public DataFetcher<VehicleParking> carPark() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeCarParkArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeCarParkArgs(environment.getArguments());
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            return vehicleParkingService.getCarParks().filter(carPark -> carPark.getId().getId().equals(args.getLegacyGraphQLId())).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Iterable<VehicleParking>> carParks() {
        return environment -> {
            List idList;
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeCarParksArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeCarParksArgs(environment.getArguments());
            if (args.getLegacyGraphQLIds() != null && !(idList = (List)args.getLegacyGraphQLIds()).isEmpty()) {
                Map<String, VehicleParking> carParkMap = vehicleParkingService.getCarParks().collect(Collectors.toMap(station -> station.getId().getId(), station -> station));
                return idList.stream().map(carParkMap::get).collect(Collectors.toList());
            }
            return vehicleParkingService.getCarParks().collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Object> cluster() {
        return environment -> null;
    }

    @Override
    public DataFetcher<Iterable<Object>> clusters() {
        return environment -> Collections.EMPTY_LIST;
    }

    @Override
    public DataFetcher<PatternAtStop> departureRow() {
        return environment -> PatternAtStop.fromId(this.getTransitService(environment), new LegacyGraphQLTypes.LegacyGraphQLQueryTypeDepartureRowArgs(environment.getArguments()).getLegacyGraphQLId());
    }

    @Override
    public DataFetcher<Iterable<String>> feeds() {
        return environment -> this.getTransitService(environment).getFeedIds();
    }

    @Override
    public DataFetcher<Trip> fuzzyTrip() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeFuzzyTripArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeFuzzyTripArgs(environment.getArguments());
            TransitService transitService = this.getTransitService(environment);
            return new GtfsRealtimeFuzzyTripMatcher(transitService).getTrip(transitService.getRouteForId(FeedScopedId.parseId(args.getLegacyGraphQLRoute())), DIRECTION_MAPPER.map(args.getLegacyGraphQLDirection()), args.getLegacyGraphQLTime(), ServiceDateUtils.parseString(args.getLegacyGraphQLDate()));
        };
    }

    @Override
    public DataFetcher<Connection<PlaceAtDistance>> nearest() {
        return environment -> {
            List places;
            List<FeedScopedId> filterByStops = null;
            List<FeedScopedId> filterByRoutes = null;
            ArrayList filterByBikeRentalStations = null;
            ArrayList filterByBikeParks = null;
            ArrayList filterByCarParks = null;
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeNearestArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeNearestArgs(environment.getArguments());
            LegacyGraphQLTypes.LegacyGraphQLInputFiltersInput filterByIds = args.getLegacyGraphQLFilterByIds();
            if (filterByIds != null) {
                filterByStops = filterByIds.getLegacyGraphQLStops() != null ? StreamSupport.stream(filterByIds.getLegacyGraphQLStops().spliterator(), false).map(FeedScopedId::parseId).collect(Collectors.toList()) : null;
                filterByRoutes = filterByIds.getLegacyGraphQLRoutes() != null ? StreamSupport.stream(filterByIds.getLegacyGraphQLRoutes().spliterator(), false).map(FeedScopedId::parseId).collect(Collectors.toList()) : null;
                filterByBikeRentalStations = filterByIds.getLegacyGraphQLBikeRentalStations() != null ? Lists.newArrayList(filterByIds.getLegacyGraphQLBikeRentalStations()) : null;
                filterByBikeParks = filterByIds.getLegacyGraphQLBikeParks() != null ? Lists.newArrayList(filterByIds.getLegacyGraphQLBikeParks()) : null;
                filterByCarParks = filterByIds.getLegacyGraphQLCarParks() != null ? Lists.newArrayList(filterByIds.getLegacyGraphQLCarParks()) : null;
            }
            List<TransitMode> filterByModes = args.getLegacyGraphQLFilterByModes() != null ? StreamSupport.stream(args.getLegacyGraphQLFilterByModes().spliterator(), false).map(mode -> {
                try {
                    return TransitMode.valueOf(mode.name());
                }
                catch (IllegalArgumentException ignored) {
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList()) : null;
            List<PlaceType> filterByPlaceTypes = args.getLegacyGraphQLFilterByPlaceTypes() != null ? StreamSupport.stream(args.getLegacyGraphQLFilterByPlaceTypes().spliterator(), false).map(LegacyGraphQLUtils::toModel).toList() : null;
            try {
                places = new ArrayList<PlaceAtDistance>(this.getRoutingService(environment).findClosestPlaces(args.getLegacyGraphQLLat(), args.getLegacyGraphQLLon(), args.getLegacyGraphQLMaxDistance().intValue(), args.getLegacyGraphQLMaxResults(), filterByModes, filterByPlaceTypes, filterByStops, filterByRoutes, filterByBikeRentalStations, filterByBikeParks, filterByCarParks, this.getTransitService(environment)));
            }
            catch (RoutingValidationException e) {
                places = Collections.emptyList();
            }
            return new SimpleListConnection(places).get(environment);
        };
    }

    @Override
    public DataFetcher<Object> node() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeNodeArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeNodeArgs(environment.getArguments());
            String type = args.getLegacyGraphQLId().getType();
            String id = args.getLegacyGraphQLId().getId();
            RoutingService routingService = ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
            TransitService transitService = ((LegacyGraphQLRequestContext)environment.getContext()).getTransitService();
            VehicleParkingService vehicleParkingService = routingService.getVehicleParkingService();
            VehicleRentalStationService vehicleRentalStationService = routingService.getVehicleRentalStationService();
            switch (type) {
                case "Agency": {
                    return transitService.getAgencyForId(FeedScopedId.parseId(id));
                }
                case "Alert": {
                    return null;
                }
                case "BikePark": {
                    FeedScopedId bikeParkId = FeedScopedId.parseId(id);
                    return vehicleParkingService == null ? null : vehicleParkingService.getBikeParks().filter(bikePark -> bikePark.getId().equals(bikeParkId)).findAny().orElse(null);
                }
                case "BikeRentalStation": {
                    return vehicleRentalStationService == null ? null : vehicleRentalStationService.getVehicleRentalPlace(FeedScopedId.parseId(id));
                }
                case "VehicleRentalStation": {
                    return vehicleRentalStationService == null ? null : vehicleRentalStationService.getVehicleRentalStation(FeedScopedId.parseId(id));
                }
                case "RentalVehicle": {
                    return vehicleRentalStationService == null ? null : vehicleRentalStationService.getVehicleRentalVehicle(FeedScopedId.parseId(id));
                }
                case "CarPark": {
                    FeedScopedId carParkId = FeedScopedId.parseId(id);
                    return vehicleParkingService == null ? null : vehicleParkingService.getCarParks().filter(carPark -> carPark.getId().equals(carParkId)).findAny().orElse(null);
                }
                case "Cluster": {
                    return null;
                }
                case "DepartureRow": {
                    return PatternAtStop.fromId(transitService, id);
                }
                case "Pattern": {
                    return transitService.getTripPatternForId(FeedScopedId.parseId(id));
                }
                case "placeAtDistance": {
                    String[] parts = id.split(";");
                    Relay.ResolvedGlobalId internalId = new Relay().fromGlobalId(parts[1]);
                    Object place = this.node().get(DataFetchingEnvironmentImpl.newDataFetchingEnvironment((DataFetchingEnvironment)environment).source(new Object()).arguments(Map.of("id", internalId)).build());
                    return new PlaceAtDistance(place, Double.parseDouble(parts[0]));
                }
                case "Route": {
                    return transitService.getRouteForId(FeedScopedId.parseId(id));
                }
                case "Stop": {
                    return transitService.getRegularStop(FeedScopedId.parseId(id));
                }
                case "Stoptime": {
                    return null;
                }
                case "stopAtDistance": {
                    String[] parts = id.split(";");
                    RegularStop stop = transitService.getRegularStop(FeedScopedId.parseId(parts[1]));
                    return new NearbyStop(stop, Integer.parseInt(parts[0]), null, null);
                }
                case "TicketType": {
                    return null;
                }
                case "Trip": {
                    FeedScopedId scopedId = FeedScopedId.parseId(id);
                    return transitService.getTripForId(scopedId);
                }
                case "VehicleParking": {
                    FeedScopedId vehicleParkingId = FeedScopedId.parseId(id);
                    return vehicleParkingService == null ? null : vehicleParkingService.getVehicleParkings().filter(bikePark -> bikePark.getId().equals(vehicleParkingId)).findAny().orElse(null);
                }
            }
            return null;
        };
    }

    @Override
    public DataFetcher<TripPattern> pattern() {
        return environment -> this.getTransitService(environment).getTripPatternForId(FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypePatternArgs(environment.getArguments()).getLegacyGraphQLId()));
    }

    @Override
    public DataFetcher<Iterable<TripPattern>> patterns() {
        return environment -> this.getTransitService(environment).getAllTripPatterns();
    }

    @Override
    public DataFetcher<DataFetcherResult<RoutingResponse>> plan() {
        return environment -> {
            LegacyGraphQLRequestContext context = (LegacyGraphQLRequestContext)environment.getContext();
            RouteRequest request = context.getServerContext().defaultRouteRequest();
            CallerWithEnvironment callWith = new CallerWithEnvironment(environment);
            callWith.argument("fromPlace", from -> request.setFrom(LocationStringParser.fromOldStyleString(from)));
            callWith.argument("toPlace", to -> request.setTo(LocationStringParser.fromOldStyleString(to)));
            callWith.argument("from", v -> request.setFrom(LegacyGraphQLQueryTypeImpl.toGenericLocation(v)));
            callWith.argument("to", v -> request.setTo(LegacyGraphQLQueryTypeImpl.toGenericLocation(v)));
            request.setDateTime((String)environment.getArgument("date"), (String)environment.getArgument("time"), context.getServerContext().transitService().getTimeZone());
            callWith.argument("wheelchair", request::setWheelchair);
            callWith.argument("numItineraries", request::setNumItineraries);
            callWith.argument("searchWindow", m -> request.setSearchWindow(Duration.ofSeconds(m)));
            callWith.argument("pageCursor", request::setPageCursorFromEncoded);
            request.withPreferences(preferences -> {
                preferences.withBike(bike -> {
                    callWith.argument("bikeReluctance", bike::withReluctance);
                    callWith.argument("bikeWalkingReluctance", bike::withWalkingReluctance);
                    callWith.argument("bikeWalkingSpeed", bike::withWalkingSpeed);
                    callWith.argument("bikeSpeed", bike::withSpeed);
                    callWith.argument("bikeSwitchTime", bike::withSwitchTime);
                    callWith.argument("bikeSwitchCost", bike::withSwitchCost);
                    callWith.argument("bikeBoardCost", bike::withBoardCost);
                    if (environment.getArgument("optimize") != null) {
                        bike.withOptimizeType(BicycleOptimizeType.valueOf((String)environment.getArgument("optimize")));
                    }
                    if (bike.optimizeType() == BicycleOptimizeType.TRIANGLE) {
                        bike.withOptimizeTriangle(triangle -> {
                            callWith.argument("triangle.timeFactor", triangle::withTime);
                            callWith.argument("triangle.slopeFactor", triangle::withSlope);
                            callWith.argument("triangle.safetyFactor", triangle::withSafety);
                        });
                    }
                });
                preferences.withCar(car -> callWith.argument("carReluctance", car::withReluctance));
                preferences.withWalk(b -> {
                    callWith.argument("walkReluctance", b::withReluctance);
                    callWith.argument("walkSpeed", b::withSpeed);
                    callWith.argument("walkBoardCost", b::withBoardCost);
                    callWith.argument("walkSafetyFactor", b::withSafetyFactor);
                });
                preferences.withRental(rental -> {
                    callWith.argument("keepingRentedBicycleAtDestinationCost", rental::withArrivingInRentalVehicleAtDestinationCost);
                    rental.withUseAvailabilityInformation(request.isTripPlannedForNow());
                });
                callWith.argument("debugItineraryFilter", v -> preferences.withItineraryFilter(it -> it.withDebug((boolean)v)));
                preferences.withTransit(tr -> {
                    callWith.argument("boardSlack", tr::withDefaultBoardSlackSec);
                    callWith.argument("alightSlack", tr::withDefaultAlightSlackSec);
                    callWith.argument("preferred.otherThanPreferredRoutesPenalty", tr::setOtherThanPreferredRoutesPenalty);
                    callWith.argument("unpreferred.useUnpreferredRoutesPenalty", v -> tr.setUnpreferredCostString(RequestFunctions.serialize(RequestFunctions.createLinearFunction(v.intValue(), 0.0))));
                    callWith.argument("unpreferred.unpreferredCost", tr::setUnpreferredCostString);
                    callWith.argument("ignoreRealtimeUpdates", tr::setIgnoreRealtimeUpdates);
                    callWith.argument("modeWeight", modeWeights -> tr.setReluctanceForMode(modeWeights.entrySet().stream().collect(Collectors.toMap(e -> TransitMode.valueOf((String)e.getKey()), e -> (Double)e.getValue()))));
                });
                preferences.withTransfer(tx -> {
                    callWith.argument("transferPenalty", tx::withCost);
                    callWith.argument("minTransferTime", tx::withSlack);
                    callWith.argument("waitReluctance", tx::withWaitReluctance);
                    callWith.argument("maxTransfers", tx::withMaxTransfers);
                    callWith.argument("nonpreferredTransferPenalty", tx::withNonpreferredCost);
                });
            });
            callWith.argument("allowKeepingRentedBicycleAtDestination", request.journey().rental()::setAllowArrivingInRentedVehicleAtDestination);
            callWith.argument("arriveBy", request::setArriveBy);
            callWith.argument("preferred.routes", request.journey().transit()::setPreferredRoutesFromString);
            callWith.argument("preferred.agencies", request.journey().transit()::setPreferredAgenciesFromString);
            callWith.argument("unpreferred.routes", request.journey().transit()::setUnpreferredRoutesFromString);
            callWith.argument("unpreferred.agencies", request.journey().transit()::setUnpreferredAgenciesFromString);
            callWith.argument("banned.routes", request.journey().transit()::setBannedRoutesFromString);
            callWith.argument("banned.agencies", request.journey().transit()::setBannedAgenciesFromSting);
            callWith.argument("banned.trips", request.journey().transit()::setBannedTripsFromString);
            if (LegacyGraphQLQueryTypeImpl.hasArgument(environment, "transportModes")) {
                QualifiedModeSet modes = new QualifiedModeSet("WALK");
                modes.qModes = ((List)environment.getArgument("transportModes")).stream().map(transportMode -> new QualifiedMode((String)transportMode.get("mode") + (String)(transportMode.get("qualifier") == null ? "" : "_" + (String)transportMode.get("qualifier")))).collect(Collectors.toSet());
                request.journey().setModes(modes.getRequestModes());
            }
            if (LegacyGraphQLQueryTypeImpl.hasArgument(environment, "allowedTicketTypes")) {
                // empty if block
            }
            VehicleRentalRequest vehicleRental = request.journey().rental();
            callWith.argument("allowedBikeRentalNetworks", v -> vehicleRental.setAllowedNetworks(new HashSet<String>((Collection<String>)v)));
            callWith.argument("allowedVehicleRentalNetworks", v -> vehicleRental.setAllowedNetworks(new HashSet<String>((Collection<String>)v)));
            callWith.argument("bannedVehicleRentalNetworks", v -> vehicleRental.setBannedNetworks(new HashSet<String>((Collection<String>)v)));
            callWith.argument("locale", v -> request.setLocale(LegacyGraphQLUtils.getLocale(environment, v)));
            RoutingResponse res = context.getRoutingService().route(request);
            return DataFetcherResult.newResult().data((Object)res).localContext(Map.of("locale", request.locale())).build();
        };
    }

    @Override
    public DataFetcher<VehicleRentalVehicle> rentalVehicle() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeRentalVehicleArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeRentalVehicleArgs(environment.getArguments());
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            return vehicleRentalStationService.getVehicleRentalVehicles().stream().filter(vehicleRentalVehicle -> vehicleRentalVehicle.getId().toString().equals(args.getLegacyGraphQLId())).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Iterable<VehicleRentalVehicle>> rentalVehicles() {
        return environment -> {
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeRentalVehiclesArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeRentalVehiclesArgs(environment.getArguments());
            if (args.getLegacyGraphQLIds() != null) {
                ArrayListMultimap vehicleRentalVehicles = (ArrayListMultimap)vehicleRentalStationService.getVehicleRentalVehicles().stream().collect(Multimaps.toMultimap(vehicle -> vehicle.getId().toString(), vehicle -> vehicle, ArrayListMultimap::create));
                return ((List)args.getLegacyGraphQLIds()).stream().flatMap(id -> vehicleRentalVehicles.get(id).stream()).collect(Collectors.toList());
            }
            Iterable<LegacyGraphQLTypes.LegacyGraphQLFormFactor> formFactorArgs = args.getLegacyGraphQLFormFactors();
            if (formFactorArgs != null) {
                List<RentalVehicleType.FormFactor> requiredFormFactors = StreamSupport.stream(formFactorArgs.spliterator(), false).map(LegacyGraphQLUtils::toModel).toList();
                return vehicleRentalStationService.getVehicleRentalVehicles().stream().filter(v -> v.vehicleType != null).filter(v -> requiredFormFactors.contains((Object)v.vehicleType.formFactor)).toList();
            }
            return vehicleRentalStationService.getVehicleRentalVehicles();
        };
    }

    @Override
    public DataFetcher<Route> route() {
        return environment -> this.getTransitService(environment).getRouteForId(FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypeRouteArgs(environment.getArguments()).getLegacyGraphQLId()));
    }

    @Override
    public DataFetcher<Iterable<Route>> routes() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeRoutesArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeRoutesArgs(environment.getArguments());
            RoutingService routingService = this.getRoutingService(environment);
            TransitService transitService = this.getTransitService(environment);
            if (args.getLegacyGraphQLIds() != null) {
                return StreamSupport.stream(args.getLegacyGraphQLIds().spliterator(), false).map(FeedScopedId::parseId).map(transitService::getRouteForId).collect(Collectors.toList());
            }
            Stream<Route> routeStream = transitService.getAllRoutes().stream();
            if (args.getLegacyGraphQLFeeds() != null) {
                List feeds = StreamSupport.stream(args.getLegacyGraphQLFeeds().spliterator(), false).collect(Collectors.toList());
                routeStream = routeStream.filter(route -> feeds.contains(route.getId().getFeedId()));
            }
            if (args.getLegacyGraphQLTransportModes() != null) {
                List modes = StreamSupport.stream(args.getLegacyGraphQLTransportModes().spliterator(), false).map(mode -> TransitMode.valueOf(mode.name())).collect(Collectors.toList());
                routeStream = routeStream.filter(route -> modes.contains((Object)route.getMode()));
            }
            if (args.getLegacyGraphQLName() != null) {
                String name = args.getLegacyGraphQLName().toLowerCase(environment.getLocale());
                routeStream = routeStream.filter(route -> LegacyGraphQLUtils.startsWith(route.getShortName(), name, environment.getLocale()) || LegacyGraphQLUtils.startsWith(route.getLongName(), name, environment.getLocale()));
            }
            return routeStream.collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Object> serviceTimeRange() {
        return environment -> new Object();
    }

    @Override
    public DataFetcher<Object> station() {
        return environment -> this.getTransitService(environment).getStationById(FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStationArgs(environment.getArguments()).getLegacyGraphQLId()));
    }

    @Override
    public DataFetcher<Iterable<Object>> stations() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeStationsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStationsArgs(environment.getArguments());
            RoutingService routingService = this.getRoutingService(environment);
            TransitService transitService = this.getTransitService(environment);
            if (args.getLegacyGraphQLIds() != null) {
                return StreamSupport.stream(args.getLegacyGraphQLIds().spliterator(), false).map(FeedScopedId::parseId).map(transitService::getStationById).collect(Collectors.toList());
            }
            Stream<Station> stationStream = transitService.getStations().stream();
            if (args.getLegacyGraphQLName() != null) {
                String name = args.getLegacyGraphQLName().toLowerCase(environment.getLocale());
                stationStream = stationStream.filter(station -> LegacyGraphQLUtils.startsWith(station.getName(), name, environment.getLocale()));
            }
            return stationStream.collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Object> stop() {
        return environment -> this.getTransitService(environment).getRegularStop(FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopArgs(environment.getArguments()).getLegacyGraphQLId()));
    }

    @Override
    public DataFetcher<Iterable<Object>> stops() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsArgs(environment.getArguments());
            TransitService transitService = this.getTransitService(environment);
            if (args.getLegacyGraphQLIds() != null) {
                return StreamSupport.stream(args.getLegacyGraphQLIds().spliterator(), false).map(FeedScopedId::parseId).map(transitService::getRegularStop).collect(Collectors.toList());
            }
            Stream<StopLocation> stopStream = transitService.listStopLocations().stream();
            if (args.getLegacyGraphQLName() != null) {
                String name = args.getLegacyGraphQLName().toLowerCase(environment.getLocale());
                stopStream = stopStream.filter(stop -> LegacyGraphQLUtils.startsWith(stop.getName(), name, environment.getLocale()));
            }
            return stopStream.collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Iterable<Object>> stopsByBbox() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsByBboxArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsByBboxArgs(environment.getArguments());
            Envelope envelope = new Envelope(new Coordinate(args.getLegacyGraphQLMinLon().doubleValue(), args.getLegacyGraphQLMinLat().doubleValue()), new Coordinate(args.getLegacyGraphQLMaxLon().doubleValue(), args.getLegacyGraphQLMaxLat().doubleValue()));
            Stream<RegularStop> stopStream = this.getTransitService(environment).findRegularStop(envelope).stream().filter(stop -> envelope.contains(stop.getCoordinate().asJtsCoordinate()));
            if (args.getLegacyGraphQLFeeds() != null) {
                ArrayList feedIds = Lists.newArrayList(args.getLegacyGraphQLFeeds());
                stopStream = stopStream.filter(stop -> feedIds.contains(stop.getId().getFeedId()));
            }
            return stopStream.collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Connection<NearbyStop>> stopsByRadius() {
        return environment -> {
            List<Object> stops;
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsByRadiusArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeStopsByRadiusArgs(environment.getArguments());
            try {
                stops = this.getRoutingService(environment).findClosestStops(new Coordinate(args.getLegacyGraphQLLon().doubleValue(), args.getLegacyGraphQLLat().doubleValue()), args.getLegacyGraphQLRadius().intValue());
            }
            catch (RoutingValidationException e) {
                stops = Collections.emptyList();
            }
            return new SimpleListConnection(stops).get(environment);
        };
    }

    @Override
    public DataFetcher<Iterable<FareRuleSet>> ticketTypes() {
        return environment -> {
            Map<FareType, Collection<FareRuleSet>> fareRules = ((DefaultFareService)this.getFareService(environment)).getFareRulesPerType();
            return fareRules.entrySet().stream().filter(entry -> entry.getKey() == FareType.regular).map(Map.Entry::getValue).flatMap(Collection::stream).toList();
        };
    }

    @Override
    public DataFetcher<Trip> trip() {
        return environment -> this.getTransitService(environment).getTripForId(FeedScopedId.parseId(new LegacyGraphQLTypes.LegacyGraphQLQueryTypeTripArgs(environment.getArguments()).getLegacyGraphQLId()));
    }

    @Override
    public DataFetcher<Iterable<Trip>> trips() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeTripsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeTripsArgs(environment.getArguments());
            Stream<Trip> tripStream = this.getTransitService(environment).getAllTrips().stream();
            if (args.getLegacyGraphQLFeeds() != null) {
                List feeds = StreamSupport.stream(args.getLegacyGraphQLFeeds().spliterator(), false).collect(Collectors.toList());
                tripStream = tripStream.filter(trip -> feeds.contains(trip.getId().getFeedId()));
            }
            return tripStream.collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<VehicleParking> vehicleParking() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleParkingArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleParkingArgs(environment.getArguments());
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            FeedScopedId vehicleParkingId = FeedScopedId.parseId(args.getLegacyGraphQLId());
            return vehicleParkingService.getVehicleParkings().filter(vehicleParking -> vehicleParking.getId().equals(vehicleParkingId)).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Iterable<VehicleParking>> vehicleParkings() {
        return environment -> {
            List idList;
            VehicleParkingService vehicleParkingService = this.getRoutingService(environment).getVehicleParkingService();
            if (vehicleParkingService == null) {
                return null;
            }
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleParkingsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleParkingsArgs(environment.getArguments());
            if (args.getLegacyGraphQLIds() != null && !(idList = (List)args.getLegacyGraphQLIds()).isEmpty()) {
                Map<String, VehicleParking> vehicleParkingMap = vehicleParkingService.getVehicleParkings().collect(Collectors.toMap(station -> station.getId().toString(), station -> station));
                return idList.stream().map(vehicleParkingMap::get).collect(Collectors.toList());
            }
            return vehicleParkingService.getVehicleParkings().collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<VehicleRentalStation> vehicleRentalStation() {
        return environment -> {
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleRentalStationArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleRentalStationArgs(environment.getArguments());
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            return vehicleRentalStationService.getVehicleRentalStations().stream().filter(vehicleRentalStation -> vehicleRentalStation.getId().toString().equals(args.getLegacyGraphQLId())).findAny().orElse(null);
        };
    }

    @Override
    public DataFetcher<Iterable<VehicleRentalStation>> vehicleRentalStations() {
        return environment -> {
            VehicleRentalStationService vehicleRentalStationService = this.getRoutingService(environment).getVehicleRentalStationService();
            if (vehicleRentalStationService == null) {
                return null;
            }
            LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleRentalStationsArgs args = new LegacyGraphQLTypes.LegacyGraphQLQueryTypeVehicleRentalStationsArgs(environment.getArguments());
            if (args.getLegacyGraphQLIds() != null) {
                ArrayListMultimap vehicleRentalStations = (ArrayListMultimap)vehicleRentalStationService.getVehicleRentalStations().stream().collect(Multimaps.toMultimap(station -> station.getId().toString(), station -> station, ArrayListMultimap::create));
                return ((List)args.getLegacyGraphQLIds()).stream().flatMap(id -> vehicleRentalStations.get(id).stream()).collect(Collectors.toList());
            }
            return vehicleRentalStationService.getVehicleRentalStations();
        };
    }

    @Override
    public DataFetcher<Object> viewer() {
        return environment -> new Object();
    }

    private static <T> void call(Map<String, T> m, String name, Consumer<T> consumer) {
        if (!name.contains(".")) {
            if (LegacyGraphQLQueryTypeImpl.hasArgument(m, name)) {
                T v = m.get(name);
                consumer.accept(v);
            }
        } else {
            String[] parts = name.split("\\.");
            if (LegacyGraphQLQueryTypeImpl.hasArgument(m, parts[0])) {
                Map nm = (Map)m.get(parts[0]);
                LegacyGraphQLQueryTypeImpl.call(nm, String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length)), consumer);
            }
        }
    }

    private static <T> void call(DataFetchingEnvironment environment, String name, Consumer<T> consumer) {
        if (!name.contains(".")) {
            if (LegacyGraphQLQueryTypeImpl.hasArgument(environment, name)) {
                consumer.accept(environment.getArgument(name));
            }
        } else {
            String[] parts = name.split("\\.");
            if (LegacyGraphQLQueryTypeImpl.hasArgument(environment, parts[0])) {
                Map nm = (Map)environment.getArgument(parts[0]);
                LegacyGraphQLQueryTypeImpl.call(nm, String.join((CharSequence)".", Arrays.copyOfRange(parts, 1, parts.length)), consumer);
            }
        }
    }

    private static GenericLocation toGenericLocation(Map<String, Object> m) {
        double lat = (Double)m.get("lat");
        double lng = (Double)m.get("lon");
        String address = (String)m.get("address");
        Object locationSlack = null;
        if (address != null) {
            return new GenericLocation(address, null, lat, lng);
        }
        return new GenericLocation(lat, lng);
    }

    private static boolean hasArgument(DataFetchingEnvironment environment, String name) {
        return environment.containsArgument(name) && environment.getArgument(name) != null;
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getTransitService();
    }

    private FareService getFareService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getFareService();
    }

    private static class CallerWithEnvironment {
        private final DataFetchingEnvironment environment;

        public CallerWithEnvironment(DataFetchingEnvironment e) {
            this.environment = e;
        }

        private <T> void argument(String name, Consumer<T> consumer) {
            LegacyGraphQLQueryTypeImpl.call(this.environment, name, consumer);
        }
    }
}

