/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.TypeResolutionEnvironment;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLSchema;
import graphql.schema.TypeResolver;
import org.opentripplanner.ext.legacygraphqlapi.datafetchers.LegacyGraphQLNodeTypeResolver;
import org.opentripplanner.routing.graphfinder.PatternAtStop;
import org.opentripplanner.routing.vehicle_parking.VehicleParking;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStation;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalVehicle;
import org.opentripplanner.transit.model.site.RegularStop;

public class LegacyGraphQLPlaceInterfaceTypeResolver
implements TypeResolver {
    public GraphQLObjectType getType(TypeResolutionEnvironment environment) {
        Object o = environment.getObject();
        GraphQLSchema schema = environment.getSchema();
        if (o instanceof VehicleParking) {
            VehicleParking vehicleParking = (VehicleParking)o;
            if (LegacyGraphQLNodeTypeResolver.queryContainsFragment("BikePark", environment) && vehicleParking.hasBicyclePlaces()) {
                return schema.getObjectType("BikePark");
            }
            if (LegacyGraphQLNodeTypeResolver.queryContainsFragment("CarPark", environment) && vehicleParking.hasAnyCarPlaces()) {
                return schema.getObjectType("CarPark");
            }
            return schema.getObjectType("VehicleParking");
        }
        if (o instanceof VehicleRentalStation) {
            if (LegacyGraphQLNodeTypeResolver.queryContainsFragment("BikeRentalStation", environment)) {
                return schema.getObjectType("BikeRentalStation");
            }
            return schema.getObjectType("VehicleRentalStation");
        }
        if (o instanceof VehicleRentalVehicle) {
            return schema.getObjectType("RentalVehicle");
        }
        if (o instanceof PatternAtStop) {
            return schema.getObjectType("DepartureRow");
        }
        if (o instanceof RegularStop) {
            return schema.getObjectType("Stop");
        }
        return null;
    }
}

