/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import gnu.trove.set.TIntSet;
import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.opentripplanner.api.support.SemanticHash;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLRequestContext;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLUtils;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLTypes;
import org.opentripplanner.model.vehicle_position.RealtimeVehiclePosition;
import org.opentripplanner.routing.RoutingService;
import org.opentripplanner.routing.alertpatch.EntitySelector;
import org.opentripplanner.routing.alertpatch.TransitAlert;
import org.opentripplanner.routing.services.TransitAlertService;
import org.opentripplanner.transit.model.framework.FeedScopedId;
import org.opentripplanner.transit.model.network.Route;
import org.opentripplanner.transit.model.network.TripPattern;
import org.opentripplanner.transit.model.organization.Agency;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.transit.model.timetable.TripTimes;
import org.opentripplanner.transit.service.TransitService;
import org.opentripplanner.util.time.ServiceDateUtils;

public class LegacyGraphQLPatternImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLPattern {
    @Override
    public DataFetcher<Iterable<TransitAlert>> alerts() {
        return environment -> {
            TransitAlertService alertService = this.getTransitService(environment).getTransitAlertService();
            LegacyGraphQLTypes.LegacyGraphQLPatternAlertsArgs args = new LegacyGraphQLTypes.LegacyGraphQLPatternAlertsArgs(environment.getArguments());
            Iterable<LegacyGraphQLTypes.LegacyGraphQLPatternAlertType> types = args.getLegacyGraphQLTypes();
            if (types != null) {
                ArrayList alerts = new ArrayList();
                types.forEach(type -> {
                    switch (type) {
                        case PATTERN: {
                            alerts.addAll(alertService.getDirectionAndRouteAlerts(this.getSource(environment).getDirection(), this.getRoute(environment).getId()));
                            break;
                        }
                        case AGENCY: {
                            alerts.addAll(alertService.getAgencyAlerts(this.getAgency(environment).getId()));
                            break;
                        }
                        case ROUTE: {
                            alerts.addAll(alertService.getRouteAlerts(this.getRoute(environment).getId()));
                            break;
                        }
                        case ROUTE_TYPE: {
                            int routeType = this.getRoute(environment).getGtfsType();
                            alerts.addAll(alertService.getRouteTypeAlerts(routeType, this.getSource(environment).getId().getFeedId()));
                            alerts.addAll(alertService.getRouteTypeAndAgencyAlerts(routeType, this.getAgency(environment).getId()));
                            break;
                        }
                        case TRIPS: {
                            this.getTrips(environment).forEach(trip -> alerts.addAll(alertService.getTripAlerts(trip.getId(), null)));
                            break;
                        }
                        case STOPS_ON_PATTERN: {
                            alerts.addAll(alertService.getAllAlerts().stream().filter(alert -> alert.getEntities().stream().anyMatch(entity -> entity instanceof EntitySelector.StopAndRoute && ((EntitySelector.StopAndRoute)entity).stopAndRoute.routeOrTrip.equals(this.getRoute(environment).getId()))).collect(Collectors.toList()));
                            this.getSource(environment).getStops().forEach(stop -> {
                                FeedScopedId stopId = stop.getId();
                                alerts.addAll(alertService.getStopAlerts(stopId));
                            });
                            break;
                        }
                        case STOPS_ON_TRIPS: {
                            List<Trip> trips = this.getTrips(environment);
                            trips.forEach(trip -> alerts.addAll(alertService.getAllAlerts().stream().filter(alert -> alert.getEntities().stream().anyMatch(entity -> entity instanceof EntitySelector.StopAndTrip && ((EntitySelector.StopAndTrip)entity).stopAndTrip.routeOrTrip.equals(this.getSource(environment).getId()))).collect(Collectors.toList())));
                        }
                    }
                });
                return alerts.stream().distinct().collect(Collectors.toList());
            }
            return alertService.getDirectionAndRouteAlerts(this.getSource(environment).getDirection(), this.getRoute(environment).getId());
        };
    }

    @Override
    public DataFetcher<String> code() {
        return environment -> this.getSource(environment).getId().toString();
    }

    @Override
    public DataFetcher<Integer> directionId() {
        return environment -> this.getSource((DataFetchingEnvironment)environment).getDirection().gtfsCode;
    }

    @Override
    public DataFetcher<Iterable<Coordinate>> geometry() {
        return environment -> {
            LineString geometry = this.getSource(environment).getGeometry();
            if (geometry == null) {
                return null;
            }
            return Arrays.asList(geometry.getCoordinates());
        };
    }

    @Override
    public DataFetcher<String> headsign() {
        return environment -> LegacyGraphQLUtils.getTranslation(this.getSource(environment).getTripHeadsign(), environment);
    }

    @Override
    public DataFetcher<Relay.ResolvedGlobalId> id() {
        return environment -> new Relay.ResolvedGlobalId("Pattern", this.getSource(environment).getId().toString());
    }

    @Override
    public DataFetcher<String> name() {
        return environment -> this.getSource(environment).getName();
    }

    @Override
    public DataFetcher<Geometry> patternGeometry() {
        return environment -> this.getSource(environment).getGeometry();
    }

    @Override
    public DataFetcher<Route> route() {
        return this::getRoute;
    }

    @Override
    public DataFetcher<String> semanticHash() {
        return environment -> SemanticHash.forTripPattern(this.getSource(environment), null);
    }

    @Override
    public DataFetcher<Iterable<Object>> stops() {
        return this::getStops;
    }

    @Override
    public DataFetcher<Iterable<Trip>> trips() {
        return this::getTrips;
    }

    @Override
    public DataFetcher<Iterable<Trip>> tripsForDate() {
        return environment -> {
            String serviceDate = new LegacyGraphQLTypes.LegacyGraphQLPatternTripsForDateArgs(environment.getArguments()).getLegacyGraphQLServiceDate();
            try {
                TIntSet services = this.getTransitService(environment).getServiceCodesRunningForDate(ServiceDateUtils.parseString(serviceDate));
                return this.getSource(environment).getScheduledTimetable().getTripTimes().stream().filter(times -> services.contains(times.getServiceCode())).map(TripTimes::getTrip).collect(Collectors.toList());
            }
            catch (ParseException e) {
                return null;
            }
        };
    }

    @Override
    public DataFetcher<Iterable<RealtimeVehiclePosition>> vehiclePositions() {
        return environment -> this.getRoutingService(environment).getVehiclePositionService().getVehiclePositions(this.getSource(environment));
    }

    private Agency getAgency(DataFetchingEnvironment environment) {
        return this.getRoute(environment).getAgency();
    }

    private Route getRoute(DataFetchingEnvironment environment) {
        return this.getSource(environment).getRoute();
    }

    private List<Object> getStops(DataFetchingEnvironment environment) {
        return this.getSource(environment).getStops().stream().map(Object.class::cast).collect(Collectors.toList());
    }

    private List<Trip> getTrips(DataFetchingEnvironment environment) {
        return this.getSource(environment).scheduledTripsAsStream().collect(Collectors.toList());
    }

    private RoutingService getRoutingService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getRoutingService();
    }

    private TransitService getTransitService(DataFetchingEnvironment environment) {
        return ((LegacyGraphQLRequestContext)environment.getContext()).getTransitService();
    }

    private TripPattern getSource(DataFetchingEnvironment environment) {
        return (TripPattern)environment.getSource();
    }
}

