/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.legacygraphqlapi.datafetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.opentripplanner.ext.legacygraphqlapi.generated.LegacyGraphQLDataFetchers;
import org.opentripplanner.model.SystemNotice;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.core.ItineraryFares;

public class LegacyGraphQLItineraryImpl
implements LegacyGraphQLDataFetchers.LegacyGraphQLItinerary {
    @Override
    public DataFetcher<Boolean> arrivedAtDestinationWithRentedBicycle() {
        return environment -> this.getSource(environment).isArrivedAtDestinationWithRentedVehicle();
    }

    @Override
    public DataFetcher<Long> duration() {
        return environment -> this.getSource(environment).getDuration().toSeconds();
    }

    @Override
    public DataFetcher<Double> elevationGained() {
        return environment -> this.getSource(environment).getElevationGained();
    }

    @Override
    public DataFetcher<Double> elevationLost() {
        return environment -> this.getSource(environment).getElevationLost();
    }

    @Override
    public DataFetcher<Long> endTime() {
        return environment -> this.getSource(environment).endTime().toInstant().toEpochMilli();
    }

    @Override
    public DataFetcher<Iterable<Map<String, Object>>> fares() {
        return environment -> {
            ItineraryFares fare = this.getSource(environment).getFares();
            if (fare == null) {
                return null;
            }
            return fare.getTypes().stream().map(fareKey -> {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("name", fareKey);
                result.put("fare", fare.getFare((FareType)fareKey));
                result.put("details", fare.getDetails((FareType)fareKey));
                return result;
            }).collect(Collectors.toList());
        };
    }

    @Override
    public DataFetcher<Integer> generalizedCost() {
        return environment -> this.getSource(environment).getGeneralizedCost();
    }

    @Override
    public DataFetcher<Iterable<Leg>> legs() {
        return environment -> this.getSource(environment).getLegs();
    }

    @Override
    public DataFetcher<Long> startTime() {
        return environment -> this.getSource(environment).startTime().toInstant().toEpochMilli();
    }

    @Override
    public DataFetcher<Iterable<SystemNotice>> systemNotices() {
        return environment -> this.getSource(environment).getSystemNotices();
    }

    @Override
    public DataFetcher<Long> waitingTime() {
        return environment -> this.getSource(environment).getWaitingDuration().toSeconds();
    }

    @Override
    public DataFetcher<Double> walkDistance() {
        return environment -> this.getSource(environment).getNonTransitDistanceMeters();
    }

    @Override
    public DataFetcher<Long> walkTime() {
        return environment -> this.getSource(environment).getNonTransitDuration().toSeconds();
    }

    private Itinerary getSource(DataFetchingEnvironment environment) {
        return (Itinerary)environment.getSource();
    }
}

