/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.template;

import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import org.opentripplanner.ext.flex.FlexParameters;
import org.opentripplanner.ext.flex.FlexServiceDate;
import org.opentripplanner.ext.flex.edgetype.FlexTripEdge;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.ext.flex.template.FlexAccessEgressTemplate;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.model.PathTransfer;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.algorithm.mapping.GraphPathToItineraryMapper;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.graphfinder.NearbyStop;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.transit.model.site.RegularStop;
import org.opentripplanner.transit.model.site.StopLocation;
import org.opentripplanner.transit.service.TransitService;

public class FlexAccessTemplate
extends FlexAccessEgressTemplate {
    public FlexAccessTemplate(NearbyStop accessEgress, FlexTrip trip, int fromStopTime, int toStopTime, StopLocation transferStop, FlexServiceDate date, FlexPathCalculator calculator, FlexParameters flexParams) {
        super(accessEgress, trip, fromStopTime, toStopTime, transferStop, date, calculator, flexParams);
    }

    public Itinerary createDirectGraphPath(NearbyStop egress, boolean arriveBy, int departureTime, ZonedDateTime startOfTime, GraphPathToItineraryMapper graphPathToItineraryMapper) {
        int timeShift;
        List<Edge> egressEdges = egress.edges;
        Vertex flexToVertex = egress.state.getVertex();
        if (!this.isRouteable(flexToVertex)) {
            return null;
        }
        FlexTripEdge flexEdge = this.getFlexEdge(flexToVertex, egress.stop);
        State state = flexEdge.traverse(this.accessEgress.state);
        for (Edge e : egressEdges) {
            state = e.traverse(state);
        }
        int[] flexTimes = this.getFlexTimes(flexEdge, state);
        int preFlexTime = flexTimes[0];
        int flexTime = flexTimes[1];
        int postFlexTime = flexTimes[2];
        if (arriveBy) {
            int lastStopArrivalTime = departureTime - postFlexTime - this.secondsFromStartOfTime;
            int latestArrivalTime = this.trip.latestArrivalTime(lastStopArrivalTime, this.fromStopIndex, this.toStopIndex, flexTime);
            if (latestArrivalTime == -1) {
                return null;
            }
            timeShift = this.secondsFromStartOfTime + latestArrivalTime - flexTime - preFlexTime;
        } else {
            int firstStopDepartureTime = departureTime + preFlexTime - this.secondsFromStartOfTime;
            int earliestDepartureTime = this.trip.earliestDepartureTime(firstStopDepartureTime, this.fromStopIndex, this.toStopIndex, flexTime);
            if (earliestDepartureTime == -1) {
                return null;
            }
            timeShift = this.secondsFromStartOfTime + earliestDepartureTime - preFlexTime;
        }
        ZonedDateTime startTime = startOfTime.plusSeconds(timeShift);
        return graphPathToItineraryMapper.generateItinerary(new GraphPath(state)).withTimeShiftToStartAt(startTime);
    }

    @Override
    protected List<Edge> getTransferEdges(PathTransfer transfer) {
        return transfer.getEdges();
    }

    @Override
    protected RegularStop getFinalStop(PathTransfer transfer) {
        return transfer.to instanceof RegularStop ? (RegularStop)transfer.to : null;
    }

    @Override
    protected Collection<PathTransfer> getTransfersFromTransferStop(TransitService transitService) {
        return transitService.getTransfersByStop(this.transferStop);
    }

    @Override
    protected Vertex getFlexVertex(Edge edge) {
        return edge.getFromVertex();
    }

    @Override
    protected int[] getFlexTimes(FlexTripEdge flexEdge, State state) {
        int preFlexTime = (int)this.accessEgress.state.getElapsedTimeSeconds();
        int edgeTimeInSeconds = flexEdge.getTimeInSeconds();
        int postFlexTime = (int)state.getElapsedTimeSeconds() - preFlexTime - edgeTimeInSeconds;
        return new int[]{preFlexTime, edgeTimeInSeconds, postFlexTime};
    }

    @Override
    protected FlexTripEdge getFlexEdge(Vertex flexToVertex, StopLocation transferStop) {
        return new FlexTripEdge(this.accessEgress.state.getVertex(), flexToVertex, this.accessEgress.stop, transferStop, this.trip, this, this.calculator);
    }

    protected boolean isRouteable(Vertex flexVertex) {
        if (this.accessEgress.state.getVertex() == flexVertex) {
            return false;
        }
        return this.calculator.calculateFlexPath(this.accessEgress.state.getVertex(), flexVertex, this.fromStopIndex, this.toStopIndex) != null;
    }
}

