/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex.flexpathcalculator;

import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPath;
import org.opentripplanner.ext.flex.flexpathcalculator.FlexPathCalculator;
import org.opentripplanner.routing.algorithm.astar.AStarBuilder;
import org.opentripplanner.routing.api.request.RouteRequest;
import org.opentripplanner.routing.api.request.StreetMode;
import org.opentripplanner.routing.api.request.request.StreetRequest;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.spt.DominanceFunction;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.routing.spt.ShortestPathTree;

public class StreetFlexPathCalculator
implements FlexPathCalculator {
    private static final Duration MAX_FLEX_TRIP_DURATION = Duration.ofMinutes(45L);
    private final Map<Vertex, ShortestPathTree> cache = new HashMap<Vertex, ShortestPathTree>();
    private final boolean reverseDirection;

    public StreetFlexPathCalculator(boolean reverseDirection) {
        this.reverseDirection = reverseDirection;
    }

    @Override
    public FlexPath calculateFlexPath(Vertex fromv, Vertex tov, int fromStopIndex, int toStopIndex) {
        ShortestPathTree shortestPathTree;
        Vertex destinationVertex;
        Vertex originVertex = this.reverseDirection ? tov : fromv;
        Vertex vertex = destinationVertex = this.reverseDirection ? fromv : tov;
        if (this.cache.containsKey(originVertex)) {
            shortestPathTree = this.cache.get(originVertex);
        } else {
            shortestPathTree = this.routeToMany(originVertex);
            this.cache.put(originVertex, shortestPathTree);
        }
        GraphPath path = shortestPathTree.getPath(destinationVertex);
        if (path == null) {
            return null;
        }
        int distance = (int)path.getDistanceMeters();
        int duration = path.getDuration();
        return new FlexPath(distance, duration, path::getGeometry);
    }

    private ShortestPathTree routeToMany(Vertex vertex) {
        RouteRequest routingRequest = new RouteRequest();
        routingRequest.setArriveBy(this.reverseDirection);
        return AStarBuilder.allDirectionsMaxDuration(MAX_FLEX_TRIP_DURATION).setDominanceFunction(new DominanceFunction.EarliestArrival()).setRequest(routingRequest).setStreetRequest(new StreetRequest(StreetMode.CAR)).setFrom(this.reverseDirection ? null : vertex).setTo(this.reverseDirection ? vertex : null).getShortestPathTree();
    }
}

