/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import java.util.ArrayList;
import java.util.List;
import org.opentripplanner.ext.flex.trip.FlexTrip;
import org.opentripplanner.ext.flex.trip.ScheduledDeviatedTrip;
import org.opentripplanner.ext.flex.trip.ScheduledDeviatedTripBuilder;
import org.opentripplanner.ext.flex.trip.UnscheduledTrip;
import org.opentripplanner.ext.flex.trip.UnscheduledTripBuilder;
import org.opentripplanner.graph_builder.DataImportIssueStore;
import org.opentripplanner.model.PickDrop;
import org.opentripplanner.model.StopTime;
import org.opentripplanner.model.TripStopTimes;
import org.opentripplanner.model.impl.OtpTransitServiceBuilder;
import org.opentripplanner.transit.model.timetable.Trip;
import org.opentripplanner.util.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexTripsMapper {
    private static final Logger LOG = LoggerFactory.getLogger(FlexTripsMapper.class);

    public static List<FlexTrip<?, ?>> createFlexTrips(OtpTransitServiceBuilder builder, DataImportIssueStore store) {
        ArrayList result = new ArrayList();
        TripStopTimes stopTimesByTrip = builder.getStopTimesSortedByTrip();
        int tripSize = stopTimesByTrip.size();
        ProgressTracker progress = ProgressTracker.track("Create flex trips", 500, tripSize);
        for (Trip trip : stopTimesByTrip.keys()) {
            ArrayList<StopTime> stopTimes = new ArrayList<StopTime>(stopTimesByTrip.get(trip));
            if (UnscheduledTrip.isUnscheduledTrip(stopTimes)) {
                result.add((FlexTrip)((UnscheduledTripBuilder)UnscheduledTrip.of(trip.getId()).withTrip(trip)).withStopTimes(stopTimes).build());
            } else if (ScheduledDeviatedTrip.isScheduledFlexTrip(stopTimes)) {
                result.add((FlexTrip)((ScheduledDeviatedTripBuilder)ScheduledDeviatedTrip.of(trip.getId()).withTrip(trip)).withStopTimes(stopTimes).build());
            } else if (FlexTripsMapper.hasContinuousStops(stopTimes) && FlexTrip.containsFlexStops(stopTimes)) {
                store.add("ContinuousFlexTrip", "Trip %s contains both flex stops and continuous pick up/drop off. This is an invalid combination: https://github.com/MobilityData/gtfs-flex/issues/70", trip.getId());
            }
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
        LOG.info("Done creating flex trips. Created a total of {} trips.", (Object)result.size());
        return result;
    }

    private static boolean hasContinuousStops(List<StopTime> stopTimes) {
        return stopTimes.stream().anyMatch(st -> st.getFlexContinuousPickup() != PickDrop.NONE || st.getFlexContinuousDropOff() != PickDrop.NONE);
    }
}

