/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.flex;

import java.util.HashSet;
import javax.inject.Inject;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.opentripplanner.graph_builder.model.GraphBuilderModule;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.impl.StreetVertexIndex;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.transit.model.site.AreaStop;
import org.opentripplanner.transit.service.TransitModel;
import org.opentripplanner.util.geometry.GeometryUtils;
import org.opentripplanner.util.logging.ProgressTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlexLocationsToStreetEdgesMapper
implements GraphBuilderModule {
    private static final Logger LOG = LoggerFactory.getLogger(FlexLocationsToStreetEdgesMapper.class);
    private final Graph graph;
    private final TransitModel transitModel;

    @Inject
    public FlexLocationsToStreetEdgesMapper(Graph graph, TransitModel transitModel) {
        this.graph = graph;
        this.transitModel = transitModel;
    }

    @Override
    public void buildGraph() {
        if (!this.transitModel.getStopModel().hasAreaStops()) {
            return;
        }
        StreetVertexIndex streetIndex = this.graph.getStreetIndexSafe(this.transitModel.getStopModel());
        ProgressTracker progress = ProgressTracker.track("Add flex locations to street vertices", 1, this.transitModel.getStopModel().listAreaStops().size());
        LOG.info(progress.startMessage());
        for (AreaStop areaStop : this.transitModel.getStopModel().listAreaStops()) {
            for (Vertex vertx : streetIndex.getVerticesForEnvelope(areaStop.getGeometry().getEnvelopeInternal())) {
                if (!(vertx instanceof StreetVertex)) continue;
                StreetVertex streetVertex = (StreetVertex)vertx;
                if (!((StreetVertex)vertx).isEligibleForCarPickupDropoff()) continue;
                Point p = GeometryUtils.getGeometryFactory().createPoint(vertx.getCoordinate());
                if (areaStop.getGeometry().disjoint((Geometry)p)) continue;
                if (streetVertex.areaStops == null) {
                    streetVertex.areaStops = new HashSet<AreaStop>();
                }
                streetVertex.areaStops.add(areaStop);
            }
            progress.step(m -> LOG.info(m));
        }
        LOG.info(progress.completeMessage());
    }

    @Override
    public void checkInputs() {
    }
}

