/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import com.google.common.collect.Lists;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.ext.fares.impl.DefaultFareService;
import org.opentripplanner.ext.fares.model.FareRuleSet;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.core.ItineraryFares;
import org.opentripplanner.transit.model.network.Route;

public class AtlantaFareService
extends DefaultFareService {
    private static final ZoneId NEW_YORK_ZONE_ID = ZoneId.of("America/New_York");
    public static final String COBB_AGENCY_ID = "2";
    public static final String XPRESS_AGENCY_ID = "6";
    public static final String MARTA_AGENCY_ID = "5";
    public static final String GCT_AGENCY_ID = "4";
    public static final Set<String> COBB_FREE_RIDE_SHORT_NAMES = Set.of("blue", "green");

    protected float getLegPrice(Leg leg, FareType fareType, Collection<FareRuleSet> fareRules) {
        return this.calculateCost(fareType, Lists.newArrayList((Object[])new Leg[]{leg}), fareRules);
    }

    private static RideType classify(Leg ride) {
        Route getRoute = ride.getRoute();
        String shortName = getRoute.getShortName().toLowerCase();
        switch (getRoute.getAgency().getId().getId()) {
            case "2": {
                if (RideType.COBB_EXPRESS.routeNamesContains(shortName)) {
                    return RideType.COBB_EXPRESS;
                }
                if (COBB_FREE_RIDE_SHORT_NAMES.contains(shortName)) {
                    return RideType.FREE_RIDE;
                }
                return RideType.COBB_LOCAL;
            }
            case "6": {
                long hours = ride.getStartTime().withZoneSameInstant(NEW_YORK_ZONE_ID).getHour();
                if (hours >= 12L) {
                    return RideType.XPRESS_AFTERNOON;
                }
                return RideType.XPRESS_MORNING;
            }
            case "4": {
                if (RideType.GCT_EXPRESS_Z1.routeNamesContains(shortName)) {
                    return RideType.GCT_EXPRESS_Z1;
                }
                if (RideType.GCT_EXPRESS_Z2.routeNamesContains(shortName)) {
                    return RideType.GCT_EXPRESS_Z2;
                }
                return RideType.GCT_LOCAL;
            }
        }
        if (RideType.STREETCAR.routeNamesContains(shortName)) {
            return RideType.STREETCAR;
        }
        return RideType.MARTA;
    }

    private static int getMaxTransfers(RideType rideType) {
        return switch (rideType) {
            case RideType.GCT_EXPRESS_Z1, RideType.GCT_LOCAL, RideType.GCT_EXPRESS_Z2 -> 3;
            default -> 4;
        };
    }

    private static Duration getTransferWindow(RideType ignored) {
        return Duration.ofHours(3L);
    }

    private static TransferMeta classifyTransfer(RideType toRideType, RideType fromRideType, FareType fareType) {
        switch (toRideType) {
            case STREETCAR: 
            case FREE_RIDE: {
                return new TransferMeta(TransferType.NO_TRANSFER);
            }
            case COBB_LOCAL: {
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    if (fromRideType == RideType.COBB_LOCAL || fromRideType == RideType.COBB_EXPRESS) {
                        return new TransferMeta(TransferType.FREE_TRANSFER);
                    }
                    return new TransferMeta(TransferType.END_TRANSFER);
                }
                return switch (fromRideType) {
                    case RideType.COBB_LOCAL, RideType.COBB_EXPRESS, RideType.MARTA -> new TransferMeta(TransferType.FREE_TRANSFER);
                    default -> new TransferMeta(TransferType.END_TRANSFER);
                };
            }
            case COBB_EXPRESS: {
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    return switch (fromRideType) {
                        case RideType.COBB_EXPRESS -> new TransferMeta(TransferType.FREE_TRANSFER);
                        case RideType.COBB_LOCAL -> new TransferMeta(TransferType.TRANSFER_PAY_DIFFERENCE);
                        default -> new TransferMeta(TransferType.END_TRANSFER);
                    };
                }
                return switch (fromRideType) {
                    case RideType.COBB_EXPRESS, RideType.MARTA -> new TransferMeta(TransferType.FREE_TRANSFER);
                    case RideType.COBB_LOCAL -> new TransferMeta(TransferType.TRANSFER_PAY_DIFFERENCE);
                    default -> new TransferMeta(TransferType.NO_TRANSFER);
                };
            }
            case MARTA: {
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    return new TransferMeta(TransferType.END_TRANSFER);
                }
                return switch (fromRideType) {
                    case RideType.GCT_EXPRESS_Z1, RideType.GCT_LOCAL, RideType.GCT_EXPRESS_Z2, RideType.COBB_LOCAL, RideType.COBB_EXPRESS, RideType.MARTA, RideType.XPRESS_AFTERNOON, RideType.XPRESS_MORNING -> new TransferMeta(TransferType.FREE_TRANSFER);
                    default -> new TransferMeta(TransferType.END_TRANSFER);
                };
            }
            case XPRESS_AFTERNOON: 
            case XPRESS_MORNING: {
                boolean payOnExit;
                boolean bl = payOnExit = toRideType == RideType.XPRESS_AFTERNOON;
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    return new TransferMeta(TransferType.END_TRANSFER);
                }
                return switch (fromRideType) {
                    case RideType.GCT_EXPRESS_Z1, RideType.GCT_EXPRESS_Z2, RideType.COBB_EXPRESS, RideType.MARTA, RideType.XPRESS_AFTERNOON, RideType.XPRESS_MORNING -> new TransferMeta(TransferType.FREE_TRANSFER, 0, payOnExit);
                    case RideType.COBB_LOCAL -> new TransferMeta(TransferType.TRANSFER_WITH_UPCHARGE, 150, payOnExit);
                    case RideType.GCT_LOCAL -> new TransferMeta(TransferType.TRANSFER_WITH_UPCHARGE, 100, payOnExit);
                    default -> new TransferMeta(TransferType.END_TRANSFER);
                };
            }
            case GCT_LOCAL: {
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    return new TransferMeta(TransferType.END_TRANSFER);
                }
                return switch (fromRideType) {
                    case RideType.GCT_EXPRESS_Z1, RideType.GCT_LOCAL, RideType.GCT_EXPRESS_Z2, RideType.MARTA -> new TransferMeta(TransferType.FREE_TRANSFER);
                    default -> new TransferMeta(TransferType.END_TRANSFER);
                };
            }
            case GCT_EXPRESS_Z1: 
            case GCT_EXPRESS_Z2: {
                if (!AtlantaFareService.isElectronicPayment(fareType)) {
                    return new TransferMeta(TransferType.END_TRANSFER);
                }
                return switch (fromRideType) {
                    case RideType.MARTA -> new TransferMeta(TransferType.FREE_TRANSFER);
                    case RideType.GCT_EXPRESS_Z1, RideType.GCT_LOCAL, RideType.GCT_EXPRESS_Z2 -> new TransferMeta(TransferType.TRANSFER_PAY_DIFFERENCE);
                    default -> new TransferMeta(TransferType.END_TRANSFER);
                };
            }
        }
        return new TransferMeta(TransferType.END_TRANSFER);
    }

    private static boolean isElectronicPayment(FareType fareType) {
        return fareType.equals(FareType.electronicRegular) || fareType.equals(FareType.electronicSenior) || fareType.equals(FareType.electronicSpecial) || fareType.equals(FareType.electronicYouth);
    }

    public AtlantaFareService(Collection<FareRuleSet> regularFareRules) {
        this.addFareRules(FareType.regular, regularFareRules);
        this.addFareRules(FareType.senior, regularFareRules);
        this.addFareRules(FareType.youth, regularFareRules);
        this.addFareRules(FareType.electronicRegular, regularFareRules);
        this.addFareRules(FareType.electronicYouth, regularFareRules);
        this.addFareRules(FareType.electronicSpecial, regularFareRules);
        this.addFareRules(FareType.electronicSenior, regularFareRules);
    }

    @Override
    public boolean populateFare(ItineraryFares fare, Currency currency, FareType fareType, List<Leg> rides, Collection<FareRuleSet> fareRules) {
        ArrayList<ATLTransfer> transfers = new ArrayList<ATLTransfer>();
        for (Leg ride : rides) {
            ATLTransfer latestTransfer;
            float defaultFare = this.getLegPrice(ride, fareType, fareRules);
            if (transfers.isEmpty()) {
                transfers.add(new ATLTransfer(currency, fareType));
            }
            if ((latestTransfer = (ATLTransfer)transfers.get(transfers.size() - 1)).addLeg(ride, defaultFare)) continue;
            ATLTransfer newXfer = new ATLTransfer(currency, fareType);
            newXfer.addLeg(ride, defaultFare);
            transfers.add(newXfer);
        }
        float cost = 0.0f;
        for (ATLTransfer transfer : transfers) {
            cost += transfer.getTotal();
        }
        fare.addFare(fareType, AtlantaFareService.getMoney(currency, cost));
        return true;
    }

    private static enum RideType {
        FREE_RIDE(new String[0]),
        MARTA(new String[0]),
        COBB_LOCAL(new String[0]),
        COBB_EXPRESS("100", "101", "102"),
        GCT_LOCAL(new String[0]),
        GCT_EXPRESS_Z1("102", "103a", "110", "swpr"),
        GCT_EXPRESS_Z2("101", "103"),
        XPRESS_MORNING(new String[0]),
        XPRESS_AFTERNOON(new String[0]),
        STREETCAR("atlsc");

        private final Set<String> routeNames;

        private RideType(String ... members) {
            this.routeNames = Arrays.stream(members).map(String::toLowerCase).collect(Collectors.toSet());
        }

        public boolean routeNamesContains(String s) {
            return this.routeNames.contains(s.toLowerCase());
        }
    }

    private static class TransferMeta {
        public final TransferType type;
        public final int upcharge;
        public final boolean payOnExit;

        public TransferMeta(TransferType type, int upcharge, boolean payOnExit) {
            this.type = type;
            this.upcharge = upcharge;
            this.payOnExit = payOnExit;
        }

        public TransferMeta(TransferType type) {
            this(type, 0, false);
        }
    }

    private static enum TransferType {
        END_TRANSFER,
        NO_TRANSFER,
        FREE_TRANSFER,
        TRANSFER_WITH_UPCHARGE,
        TRANSFER_PAY_DIFFERENCE;

    }

    private static class ATLTransfer {
        List<Leg> legs = new ArrayList<Leg>();
        List<ItineraryFares> fares = new ArrayList<ItineraryFares>();
        final FareType fareType;
        final Currency currency;
        float lastFareWithTransfer;
        int maxRides;
        Duration transferWindow;

        public ATLTransfer(Currency currency, FareType fareType) {
            this.fareType = fareType;
            this.currency = currency;
        }

        public boolean addLeg(Leg leg, float defaultFare) {
            ZonedDateTime transferUseTime;
            ItineraryFares fare = new ItineraryFares();
            RideType toRideType = AtlantaFareService.classify(leg);
            if (this.legs.size() == 0) {
                this.legs.add(leg);
                fare.addFare(this.fareType, DefaultFareService.getMoney(this.currency, defaultFare));
                this.fares.add(fare);
                this.lastFareWithTransfer = defaultFare;
                this.maxRides = AtlantaFareService.getMaxTransfers(toRideType);
                this.transferWindow = AtlantaFareService.getTransferWindow(toRideType);
                return true;
            }
            Leg latestRide = this.legs.get(this.legs.size() - 1);
            ZonedDateTime transferStartTime = this.legs.get(0).getStartTime();
            RideType fromRideType = AtlantaFareService.classify(latestRide);
            TransferMeta transferClassification = AtlantaFareService.classifyTransfer(toRideType, fromRideType, this.fareType);
            ZonedDateTime zonedDateTime = transferUseTime = transferClassification.payOnExit ? leg.getEndTime() : leg.getStartTime();
            if (!transferClassification.type.equals((Object)TransferType.NO_TRANSFER)) {
                if (transferClassification.type.equals((Object)TransferType.END_TRANSFER)) {
                    return false;
                }
                if (transferUseTime.isAfter(transferStartTime.plus(this.transferWindow))) {
                    return false;
                }
                if (this.legs.size() > this.maxRides) {
                    return false;
                }
            }
            this.fares.add(fare);
            if (transferClassification.type.equals((Object)TransferType.NO_TRANSFER)) {
                fare.addFare(this.fareType, DefaultFareService.getMoney(this.currency, defaultFare));
                return true;
            }
            this.legs.add(leg);
            if (transferClassification.type.equals((Object)TransferType.FREE_TRANSFER)) {
                fare.addFare(this.fareType, DefaultFareService.getMoney(this.currency, 0.0f));
                this.lastFareWithTransfer = defaultFare;
                return true;
            }
            if (transferClassification.type.equals((Object)TransferType.TRANSFER_PAY_DIFFERENCE)) {
                float newCost = 0.0f;
                if (defaultFare > this.lastFareWithTransfer) {
                    newCost = defaultFare - this.lastFareWithTransfer;
                }
                fare.addFare(this.fareType, DefaultFareService.getMoney(this.currency, newCost));
                this.lastFareWithTransfer = defaultFare;
                return true;
            }
            if (transferClassification.type.equals((Object)TransferType.TRANSFER_WITH_UPCHARGE)) {
                fare.addFare(this.fareType, DefaultFareService.getMoney(this.currency, (float)transferClassification.upcharge / 100.0f));
                this.lastFareWithTransfer = defaultFare;
                return true;
            }
            return true;
        }

        public float getTotal() {
            int total = 0;
            for (ItineraryFares f : this.fares) {
                total += f.getFare(this.fareType).cents();
            }
            return (float)total / 100.0f;
        }
    }
}

