/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.fares.impl;

import java.io.Serializable;
import java.util.List;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.core.ItineraryFares;
import org.opentripplanner.routing.core.Money;
import org.opentripplanner.routing.fares.FareService;

public class AddingMultipleFareService
implements FareService,
Serializable {
    private static final long serialVersionUID = -5313317664330954335L;
    private final List<FareService> subServices;

    protected AddingMultipleFareService(List<FareService> subServices) {
        this.subServices = subServices;
    }

    @Override
    public ItineraryFares getCost(Itinerary itinerary) {
        ItineraryFares fare = null;
        for (FareService subService : this.subServices) {
            ItineraryFares subFare = subService.getCost(itinerary);
            if (subFare == null) continue;
            if (fare == null) {
                fare = new ItineraryFares(subFare);
                continue;
            }
            ItineraryFares newFare = new ItineraryFares(fare);
            for (FareType fareType : FareType.values()) {
                Money cost = fare.getFare(fareType);
                Money subCost = subFare.getFare(fareType);
                if (cost == null && subCost == null) continue;
                if (cost != null && subCost == null) {
                    subCost = subFare.getFare(FareType.regular);
                } else if (cost == null && subCost != null) {
                    cost = fare.getFare(FareType.regular);
                }
                if (cost != null && subCost != null) {
                    newFare.addFare(fareType, new Money(cost.currency(), cost.cents() + subCost.cents()));
                    continue;
                }
                if (cost != null || subCost == null) continue;
                newFare.addFare(fareType, subCost);
            }
            fare = newFare;
        }
        return fare;
    }
}

