/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.datastore.gs;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.ext.datastore.gs.AbstractGsDataSource;
import org.opentripplanner.ext.datastore.gs.GsFileDataSource;
import org.opentripplanner.ext.datastore.gs.GsHelper;
import org.opentripplanner.ext.datastore.gs.GsOutFileDataSource;

public class GsDirectoryDataSource
extends AbstractGsDataSource
implements CompositeDataSource {
    private final Storage storage;

    GsDirectoryDataSource(Storage storage, BlobId blobId, FileType type) {
        super(blobId, type);
        this.storage = storage;
    }

    @Override
    public boolean exists() {
        return this.getBucket().list(new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)this.name()), Storage.BlobListOption.pageSize((long)1L), Storage.BlobListOption.currentDirectory()}).getValues().iterator().hasNext();
    }

    @Override
    public Collection<DataSource> content() {
        ArrayList<DataSource> content = new ArrayList<DataSource>();
        this.forEachChildBlob(blob -> content.add(new GsFileDataSource((Blob)blob, this.type())));
        return content;
    }

    @Override
    public DataSource entry(String name) {
        Blob blob = this.childBlob(name);
        if (blob != null) {
            return new GsFileDataSource(blob, this.type());
        }
        BlobId childBlobId = BlobId.of((String)this.bucketName(), (String)this.childPath(name));
        return new GsOutFileDataSource(this.storage, childBlobId, this.type());
    }

    @Override
    public void delete() {
        this.forEachChildBlob(rec$ -> ((Blob)rec$).delete(new Blob.BlobSourceOption[0]));
    }

    @Override
    public void close() {
    }

    private Bucket getBucket() {
        Bucket bucket = this.storage.get(this.bucketName(), new Storage.BucketGetOption[0]);
        if (bucket == null) {
            throw new IllegalArgumentException("Bucket not found: " + this.bucketName());
        }
        return bucket;
    }

    private Blob childBlob(String name) {
        return this.getBucket().get(this.childPath(name), new Storage.BlobGetOption[0]);
    }

    private String childPrefix() {
        return GsHelper.isRoot(this.blobId()) ? "" : this.name() + "/";
    }

    private String childPath(String name) {
        return this.childPrefix() + name;
    }

    private void forEachChildBlob(Consumer<Blob> consumer) {
        int pathIndex = this.childPrefix().length();
        for (Blob blob : this.listBlobs().iterateAll()) {
            String name = blob.getName().substring(pathIndex);
            if (name.contains("/")) continue;
            consumer.accept(blob);
        }
    }

    private Page<Blob> listBlobs() {
        return this.getBucket().list(new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)this.childPrefix())});
    }
}

