/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.dataoverlay.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opentripplanner.ext.dataoverlay.api.DataOverlayParameters;
import org.opentripplanner.ext.dataoverlay.api.ParameterName;
import org.opentripplanner.ext.dataoverlay.api.ParameterType;
import org.opentripplanner.ext.dataoverlay.configuration.DataOverlayParameterBindings;
import org.opentripplanner.ext.dataoverlay.configuration.ParameterBinding;
import org.opentripplanner.ext.dataoverlay.routing.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataOverlayContext {
    private static final Logger LOG = LoggerFactory.getLogger(DataOverlayContext.class);
    private final List<Parameter> parameters = new ArrayList<Parameter>();

    public DataOverlayContext(DataOverlayParameterBindings parameterBindings, DataOverlayParameters requestParameters) {
        for (ParameterName paramName : requestParameters.listParameterNames()) {
            this.addParameter(paramName, parameterBindings, requestParameters);
        }
    }

    public Iterable<? extends Parameter> getParameters() {
        return this.parameters;
    }

    private void addParameter(ParameterName paramName, DataOverlayParameterBindings parameterBindings, DataOverlayParameters requestParameters) {
        Double penalty = requestParameters.get(paramName, ParameterType.PENALTY);
        if (this.isParameterValueInvalid(penalty, paramName, ParameterType.PENALTY)) {
            return;
        }
        Double threshold = requestParameters.get(paramName, ParameterType.THRESHOLD);
        if (this.isParameterValueInvalid(threshold, paramName, ParameterType.THRESHOLD)) {
            return;
        }
        Optional<ParameterBinding> binding = parameterBindings.getParameterBinding(paramName);
        if (binding.isEmpty()) {
            LOG.warn("Request parameter config not found. Parameter: {}", (Object)paramName);
            return;
        }
        this.parameters.add(new Parameter(binding.get(), threshold, penalty));
    }

    private boolean isParameterValueInvalid(Double value, ParameterName name, ParameterType type) {
        if (value == null || value < 0.0) {
            LOG.warn("Request parameter required. Parameter: {}", (Object)DataOverlayParameters.toStringKey(name, type));
            return true;
        }
        return false;
    }
}

