/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.dataoverlay.api;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.dataoverlay.api.DataOverlayParameters;
import org.opentripplanner.ext.dataoverlay.api.ParameterName;
import org.opentripplanner.ext.dataoverlay.api.ParameterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataOverlayParametersBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DataOverlayParameters.class);
    private final Map<T2<ParameterName, ParameterType>, Double> values = new HashMap<T2<ParameterName, ParameterType>, Double>();

    public static DataOverlayParameters parseQueryParams(Map<String, List<String>> params) {
        DataOverlayParametersBuilder result = new DataOverlayParametersBuilder();
        for (String key : params.keySet()) {
            T2<ParameterName, ParameterType> name = DataOverlayParameters.resolveKey(key);
            if (name == null) continue;
            List<String> values = params.get(key);
            if (values == null || values.isEmpty()) {
                LOG.warn("The data-overlay parameter value is missing. Parameter: {}", (Object)key);
                continue;
            }
            Double value = DataOverlayParameters.resolveValue(values.get(0));
            if (value == null) {
                LOG.warn("The data-overlay parameter value is null. Parameter: {}", (Object)key);
                continue;
            }
            result.add(name, value);
        }
        return result.build();
    }

    public DataOverlayParametersBuilder add(String param, Double value) {
        return this.add(DataOverlayParameters.resolveKey(param), value);
    }

    public DataOverlayParametersBuilder add(ParameterName name, ParameterType type, Double value) {
        return this.add(new T2<ParameterName, ParameterType>(name, type), value);
    }

    private DataOverlayParametersBuilder add(T2<ParameterName, ParameterType> param, Double value) {
        if (param != null) {
            this.values.put(param, value);
        }
        return this;
    }

    public DataOverlayParameters build() {
        return new DataOverlayParameters(this.values);
    }
}

