/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.ext.dataoverlay.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.common.model.T2;
import org.opentripplanner.ext.dataoverlay.api.DataOverlayParametersBuilder;
import org.opentripplanner.ext.dataoverlay.api.ParameterName;
import org.opentripplanner.ext.dataoverlay.api.ParameterType;
import org.opentripplanner.util.lang.ToStringBuilder;

public class DataOverlayParameters
implements Serializable {
    private final Map<T2<ParameterName, ParameterType>, Double> values;

    public DataOverlayParameters(Map<T2<ParameterName, ParameterType>, Double> values) {
        this.values = Map.copyOf(values);
    }

    public static DataOverlayParameters parseQueryParams(Map<String, List<String>> params) {
        return DataOverlayParametersBuilder.parseQueryParams(params);
    }

    public static List<String> parametersAsString() {
        ArrayList<String> list = new ArrayList<String>();
        for (ParameterName name : ParameterName.values()) {
            for (ParameterType type : ParameterType.values()) {
                list.add((name + "_" + type).toLowerCase());
            }
        }
        return list;
    }

    public static String toStringKey(ParameterName name, ParameterType type) {
        return (name + "_" + type).toLowerCase();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public Double get(String param) {
        return this.get(DataOverlayParameters.resolveKey(param));
    }

    public Double get(ParameterName name, ParameterType type) {
        return this.values.get(new T2<ParameterName, ParameterType>(name, type));
    }

    public Iterable<ParameterName> listParameterNames() {
        return this.values.keySet().stream().map(it -> (ParameterName)((Object)((Object)it.first))).collect(Collectors.toSet());
    }

    @Nullable
    static T2<ParameterName, ParameterType> resolveKey(String parameter) {
        try {
            int pos = parameter.lastIndexOf(95);
            if (pos < 0 || pos > parameter.length() - 2) {
                return null;
            }
            ParameterName name = ParameterName.valueOf(parameter.substring(0, pos).toUpperCase());
            ParameterType type = ParameterType.valueOf(parameter.substring(pos + 1).toUpperCase());
            return new T2<ParameterName, ParameterType>(name, type);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    static String keyAsString(T2<ParameterName, ParameterType> key) {
        return ((ParameterName)((Object)key.first)).name() + "_" + ((ParameterType)((Object)key.second)).name();
    }

    @Nullable
    static Double resolveValue(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NullPointerException | NumberFormatException ignore) {
            return null;
        }
    }

    private Double get(T2<ParameterName, ParameterType> param) {
        return this.values.get(param);
    }

    public String toString() {
        ToStringBuilder buf = ToStringBuilder.of(DataOverlayParameters.class);
        List<String> keys = this.values.keySet().stream().map(DataOverlayParameters::keyAsString).sorted().toList();
        for (String key : keys) {
            buf.addObj(key, this.get(key));
        }
        return buf.toString();
    }
}

