/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.https;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.DateUtils;
import org.opentripplanner.util.lang.ToStringBuilder;

class HttpsDataSourceMetadata {
    static final String CONTENT_TYPE_APPLICATION_GZIP = "application/gzip";
    static final String CONTENT_TYPE_APPLICATION_ZIP = "application/zip";
    private static final Set<String> HTTP_HEADERS = Set.of("Content-Type", "Content-Length", "Last-Modified");
    private final String contentType;
    private final long contentLength;
    private final long lastModified;

    HttpsDataSourceMetadata(List<Header> headers) {
        this(headers.stream().filter(header -> HTTP_HEADERS.contains(header.getName())).collect(Collectors.toUnmodifiableMap(NameValuePair::getName, NameValuePair::getValue)));
    }

    HttpsDataSourceMetadata(Map<String, String> headers) {
        this.contentType = headers.get("Content-Type");
        this.contentLength = HttpsDataSourceMetadata.parseLong(headers.get("Content-Length"));
        this.lastModified = HttpsDataSourceMetadata.parseDate(headers.get("Last-Modified"));
    }

    String contentType() {
        return this.contentType;
    }

    long contentLength() {
        return this.contentLength;
    }

    long lastModified() {
        return this.lastModified;
    }

    boolean isZipContentType() {
        return CONTENT_TYPE_APPLICATION_ZIP.equalsIgnoreCase(this.contentType());
    }

    boolean isGzipContentType() {
        return CONTENT_TYPE_APPLICATION_GZIP.equalsIgnoreCase(this.contentType());
    }

    private static long parseDate(String lastModifiedHeader) {
        Date lastModifiedDate;
        if (lastModifiedHeader != null && (lastModifiedDate = DateUtils.parseDate((String)lastModifiedHeader)) != null) {
            return lastModifiedDate.getTime();
        }
        return -1L;
    }

    private static long parseLong(String header) {
        try {
            return Long.parseLong(header);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public String toString() {
        return ToStringBuilder.of(this.getClass()).addObj("contentType", this.contentType).addObj("contentLength", this.contentLength).addObj("lastModified", this.lastModified).toString();
    }
}

