/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.datastore.file;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.opentripplanner.datastore.api.CompositeDataSource;
import org.opentripplanner.datastore.api.DataSource;
import org.opentripplanner.datastore.api.FileType;
import org.opentripplanner.datastore.base.LocalDataSourceRepository;
import org.opentripplanner.datastore.file.DirectoryDataSource;
import org.opentripplanner.datastore.file.FileDataSource;
import org.opentripplanner.datastore.file.ZipFileDataSource;
import org.opentripplanner.standalone.config.OtpConfigLoader;
import org.opentripplanner.util.OtpAppException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDataSourceRepository
implements LocalDataSourceRepository {
    private static final Logger LOG = LoggerFactory.getLogger(FileDataSourceRepository.class);
    private final File baseDir;
    private final Pattern gtfsLocalFilePattern;
    private final Pattern netexLocalFilePattern;
    private final Pattern osmLocalFilePattern;
    private final Pattern demLocalFilePattern;

    public FileDataSourceRepository(File baseDir, Pattern gtfsLocalFilePattern, Pattern netexLocalFilePattern, Pattern osmLocalFilePattern, Pattern demLocalFilePattern) {
        this.baseDir = baseDir;
        this.gtfsLocalFilePattern = gtfsLocalFilePattern;
        this.netexLocalFilePattern = netexLocalFilePattern;
        this.osmLocalFilePattern = osmLocalFilePattern;
        this.demLocalFilePattern = demLocalFilePattern;
    }

    @Nonnull
    public static CompositeDataSource compositeSource(File file, FileType type) {
        return FileDataSourceRepository.createCompositeSource(file, type);
    }

    @Override
    public String description() {
        return this.baseDir.getPath();
    }

    @Override
    public void open() {
    }

    @Override
    public DataSource findSource(@Nonnull URI uri, @Nonnull FileType type) {
        return new FileDataSource(this.openFile(uri, type), type);
    }

    @Override
    public CompositeDataSource findCompositeSource(@Nonnull URI uri, @Nonnull FileType type) {
        return FileDataSourceRepository.createCompositeSource(this.openFile(uri, type), type);
    }

    @Override
    public DataSource findSource(String filename, FileType type) {
        return new FileDataSource(new File(this.baseDir, filename), type);
    }

    @Override
    public CompositeDataSource findCompositeSource(String localFilename, FileType type) {
        File file = LocalDataSourceRepository.isCurrentDir(localFilename) ? this.baseDir : new File(this.baseDir, localFilename);
        return FileDataSourceRepository.createCompositeSource(file, type);
    }

    @Override
    public List<DataSource> listExistingSources(FileType type) {
        ArrayList<DataSource> existingFiles = new ArrayList<DataSource>();
        File[] files = this.baseDir.listFiles();
        if (files == null) {
            LOG.error("'{}' is not a readable input directory.", (Object)this.baseDir);
            return existingFiles;
        }
        for (File file : files) {
            if (type != this.resolveFileType(file)) continue;
            if (this.isCompositeDataSource(file)) {
                existingFiles.add(FileDataSourceRepository.createCompositeSource(file, type));
                continue;
            }
            existingFiles.add(new FileDataSource(file, type));
        }
        return existingFiles;
    }

    public String toString() {
        return "FileDataSourceRepository{baseDir=" + this.baseDir + "}";
    }

    public File openFile(URI uri, FileType type) {
        try {
            return uri.isAbsolute() ? new File(uri) : new File(this.baseDir, uri.getPath());
        }
        catch (IllegalArgumentException e) {
            throw new OtpAppException("The file URI is invalid for file type " + type + ". URI: '" + uri + "', details: " + e.getMessage());
        }
    }

    private static CompositeDataSource createCompositeSource(File file, FileType type) {
        if (file.exists() && file.isDirectory()) {
            return new DirectoryDataSource(file, type);
        }
        if (file.getName().endsWith(".zip")) {
            return new ZipFileDataSource(file, type);
        }
        if (!file.exists() && type.isOutputDataSource()) {
            return new DirectoryDataSource(file, type);
        }
        throw new IllegalArgumentException("The " + file + " is not recognized as a zip-file or directory. Unable to create composite data source for file type " + type + ".");
    }

    private static boolean isTransitFile(File file, Pattern pattern) {
        return pattern.matcher(file.getName()).find() && (file.isDirectory() || file.getName().endsWith(".zip"));
    }

    private boolean isCompositeDataSource(File file) {
        return file.isDirectory() || file.getName().endsWith(".zip");
    }

    private FileType resolveFileType(File file) {
        String name = file.getName();
        if (FileDataSourceRepository.isTransitFile(file, this.gtfsLocalFilePattern)) {
            return FileType.GTFS;
        }
        if (FileDataSourceRepository.isTransitFile(file, this.netexLocalFilePattern)) {
            return FileType.NETEX;
        }
        if (this.osmLocalFilePattern.matcher(name).find()) {
            return FileType.OSM;
        }
        if (this.demLocalFilePattern.matcher(name).find()) {
            return FileType.DEM;
        }
        if (name.matches("(?i)(street)?graph.*\\.obj")) {
            return FileType.GRAPH;
        }
        if (name.equals("report")) {
            return FileType.REPORT;
        }
        if (OtpConfigLoader.isConfigFile(name)) {
            return FileType.CONFIG;
        }
        return FileType.UNKNOWN;
    }
}

