/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.vertextype.TransitStopVertex;

public class Subgraph {
    private final Set<Vertex> streetVertexSet = new HashSet<Vertex>();
    private final Set<Vertex> stopsVertexSet = new HashSet<Vertex>();

    public void addVertex(Vertex vertex) {
        if (vertex instanceof TransitStopVertex) {
            this.stopsVertexSet.add(vertex);
        } else {
            this.streetVertexSet.add(vertex);
        }
    }

    public boolean contains(Vertex vertex) {
        return this.streetVertexSet.contains(vertex) || this.stopsVertexSet.contains(vertex);
    }

    public int streetSize() {
        return this.streetVertexSet.size();
    }

    public int stopSize() {
        return this.stopsVertexSet.size();
    }

    public Vertex getRepresentativeVertex() {
        return this.streetVertexSet.iterator().next();
    }

    public Iterator<Vertex> streetIterator() {
        return this.streetVertexSet.iterator();
    }

    public Iterator<Vertex> stopIterator() {
        return this.stopsVertexSet.iterator();
    }
}

