/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.common.geometry;

import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.TLongSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.index.ItemVisitor;
import org.locationtech.jts.index.SpatialIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HashGridSpatialIndex<T>
implements SpatialIndex,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HashGridSpatialIndex.class);
    private static final double DEFAULT_Y_BIN_SIZE = 0.005;
    private static final double DEFAULT_X_BIN_SIZE = 0.0035;
    private final double xBinSize;
    private final double yBinSize;
    private final TLongObjectHashMap<List<T>> bins;
    private int nBins = 0;
    private int nObjects = 0;
    private int nEntries = 0;

    public HashGridSpatialIndex(double xBinSize, double yBinSize) {
        if (xBinSize <= 0.0 || yBinSize <= 0.0) {
            throw new IllegalStateException("bin size must be positive.");
        }
        this.xBinSize = xBinSize;
        this.yBinSize = yBinSize;
        this.bins = new TLongObjectHashMap();
    }

    public HashGridSpatialIndex() {
        this(0.0035, 0.005);
    }

    public final void insert(Envelope envelope, Object item) {
        this.visit(envelope, true, (bin, mapKey) -> {
            bin.add(item);
            ++this.nEntries;
            return false;
        });
        ++this.nObjects;
    }

    public final List<T> query(Envelope envelope) {
        HashSet ret = new HashSet(1024);
        this.visit(envelope, false, (bin, mapKey) -> {
            ret.addAll(bin);
            return false;
        });
        return new ArrayList(ret);
    }

    public final void query(Envelope envelope, ItemVisitor visitor) {
        List<T> tlist = this.query(envelope);
        for (T t : tlist) {
            visitor.visitItem(t);
        }
    }

    public final boolean remove(Envelope envelope, Object item) {
        AtomicInteger removedCount = new AtomicInteger();
        this.visit(envelope, false, (bin, mapKey) -> {
            boolean removed = bin.remove(item);
            if (removed) {
                --this.nEntries;
                removedCount.addAndGet(1);
            }
            return removed;
        });
        if (removedCount.get() > 0) {
            --this.nObjects;
            return true;
        }
        return false;
    }

    public final void insert(LineString geom, Object item) {
        Coordinate[] coord = geom.getCoordinates();
        TLongHashSet keys = new TLongHashSet(coord.length * 8);
        for (int i = 0; i < coord.length - 1; ++i) {
            Envelope env = new Envelope(coord[i], coord[i + 1]);
            this.visit(env, true, (arg_0, arg_1) -> HashGridSpatialIndex.lambda$insert$3((TLongSet)keys, arg_0, arg_1));
        }
        keys.forEach(key -> {
            ((List)this.bins.get(key)).add(item);
            ++this.nEntries;
            return true;
        });
        ++this.nObjects;
    }

    public String toString() {
        return String.format(Locale.ROOT, "HashGridSpatialIndex %f x %f, %d bins allocated, %d objs, %d entries (avg %.2f entries/bin, %.2f entries/object)", this.xBinSize, this.yBinSize, this.nBins, this.nObjects, this.nEntries, (double)this.nEntries * 1.0 / (double)this.nBins, (double)this.nEntries * 1.0 / (double)this.nObjects);
    }

    private static Coordinate clamp(Coordinate coord) {
        if (Math.abs(coord.x) > 180.0 || Math.abs(coord.y) > 90.0) {
            LOG.warn("Corner of envelope {} was invalid, clamping to valid range. Perhaps you're buffering something near a pole?", (Object)coord);
            coord = new Coordinate(coord);
            if (coord.x > 180.0) {
                coord.x = 180.0;
            }
            if (coord.x < -180.0) {
                coord.x = -180.0;
            }
            if (coord.y > 90.0) {
                coord.y = 90.0;
            }
            if (coord.y < -90.0) {
                coord.y = -90.0;
            }
        }
        return coord;
    }

    private void visit(Envelope envelope, boolean createIfEmpty, BinVisitor<T> binVisitor) {
        Coordinate min = new Coordinate(envelope.getMinX(), envelope.getMinY());
        Coordinate max = new Coordinate(envelope.getMaxX(), envelope.getMaxY());
        min = HashGridSpatialIndex.clamp(min);
        max = HashGridSpatialIndex.clamp(max);
        long minXKey = Math.round(min.x / this.xBinSize);
        long maxXKey = Math.round(max.x / this.xBinSize);
        long minYKey = Math.round(min.y / this.yBinSize);
        long maxYKey = Math.round(max.y / this.yBinSize);
        for (long xKey = minXKey; xKey <= maxXKey; ++xKey) {
            for (long yKey = minYKey; yKey <= maxYKey; ++yKey) {
                boolean modified;
                long mapKey = yKey << 32 | (xKey & 0xFFFFL) << 16 | xKey >> 16 & 0xFFFFL;
                ArrayList bin = (ArrayList)this.bins.get(mapKey);
                if (createIfEmpty && bin == null) {
                    bin = new ArrayList();
                    this.bins.put(mapKey, bin);
                    ++this.nBins;
                }
                if (bin == null || !(modified = binVisitor.visit(bin, mapKey)) || !bin.isEmpty()) continue;
                this.bins.remove(mapKey);
                --this.nBins;
            }
        }
    }

    private static /* synthetic */ boolean lambda$insert$3(TLongSet keys, List bin, long mapKey) {
        keys.add(mapKey);
        return false;
    }

    private static interface BinVisitor<T> {
        public boolean visit(List<T> var1, long var2);
    }
}

