/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.resource;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.opentripplanner.standalone.api.OtpServerRequestContext;
import org.opentripplanner.updater.GraphUpdaterStatus;

@Path(value="/routers/{ignoreRouterId}/updaters")
@Produces(value={"application/json"})
public class UpdaterStatusResource {
    private final OtpServerRequestContext serverContext;

    public UpdaterStatusResource(@Context OtpServerRequestContext serverContext, @Deprecated @PathParam(value="ignoreRouterId") String ignoreRouterId) {
        this.serverContext = serverContext;
    }

    @GET
    public Response getUpdaters() {
        GraphUpdaterStatus updaterStatus = this.serverContext.transitService().getUpdaterStatus();
        if (updaterStatus == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No updaters running.").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(updaterStatus.getUpdaterDescriptions()).build();
    }

    @GET
    @Path(value="/{updaterId}")
    public Response getUpdaters(@PathParam(value="updaterId") int updaterId) {
        GraphUpdaterStatus updaterStatus = this.serverContext.transitService().getUpdaterStatus();
        if (updaterStatus == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No updaters running.").build();
        }
        Class<?> updater = updaterStatus.getUpdaterClass(updaterId);
        if (updater == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"No updater with that ID.").build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity(updater).build();
    }
}

