/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.parameter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import javax.ws.rs.BadRequestException;
import org.opentripplanner.api.parameter.ApiRequestMode;
import org.opentripplanner.api.parameter.Qualifier;

public class QualifiedMode
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final ApiRequestMode mode;
    public final Set<Qualifier> qualifiers;

    public QualifiedMode(String qMode) {
        try {
            ArrayList<Qualifier> qualifiers = new ArrayList<Qualifier>();
            StringBuilder mode = new StringBuilder();
            String[] elements = qMode.split("_");
            mode.append(elements[0].trim());
            for (int i = 1; i < elements.length; ++i) {
                String element = elements[i].trim();
                if (element.isBlank()) continue;
                try {
                    Qualifier q = Qualifier.valueOf(element);
                    qualifiers.add(q);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    mode.append("_");
                    mode.append(element);
                }
            }
            this.mode = ApiRequestMode.valueOf(mode.toString());
            this.qualifiers = Set.copyOf(qualifiers);
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            throw new BadRequestException("Qualified mode is not valid: '" + qMode + "', details: " + e.getMessage());
        }
    }

    public QualifiedMode(ApiRequestMode mode, Qualifier ... qualifiers) {
        this.mode = mode;
        this.qualifiers = Set.of(qualifiers);
    }

    public int hashCode() {
        return this.mode.hashCode() * this.qualifiers.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof QualifiedMode) {
            QualifiedMode qmOther = (QualifiedMode)other;
            return qmOther.mode.equals((Object)this.mode) && qmOther.qualifiers.equals(this.qualifiers);
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.mode);
        for (Qualifier qualifier : this.qualifiers) {
            sb.append("_");
            sb.append((Object)qualifier);
        }
        return sb.toString();
    }
}

