/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.mapping;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.model.plan.StreetLeg;
import org.opentripplanner.model.plan.TransitLeg;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.transit.model.basic.TransitMode;

public class ModeMapper {
    public static String mapToApi(Leg domain) {
        if (domain == null) {
            return null;
        }
        if (domain instanceof StreetLeg) {
            StreetLeg sl = (StreetLeg)domain;
            return ModeMapper.mapToApi(sl.getMode());
        }
        if (domain instanceof TransitLeg) {
            TransitLeg tl = (TransitLeg)domain;
            return ModeMapper.mapToApi(tl.getMode());
        }
        throw new IllegalStateException("Unhandled leg type: " + domain);
    }

    public static List<String> mapToApi(Set<TransitMode> domain) {
        if (domain == null) {
            return null;
        }
        return domain.stream().map(ModeMapper::mapToApi).collect(Collectors.toList());
    }

    public static String mapToApi(TraverseMode domain) {
        if (domain == null) {
            return null;
        }
        return switch (domain) {
            default -> throw new IncompatibleClassChangeError();
            case TraverseMode.BICYCLE -> "BICYCLE";
            case TraverseMode.CAR -> "CAR";
            case TraverseMode.WALK -> "WALK";
            case TraverseMode.SCOOTER -> "SCOOTER";
            case TraverseMode.FLEX -> throw new IllegalStateException();
        };
    }

    public static String mapToApi(TransitMode domain) {
        if (domain == null) {
            return null;
        }
        return switch (domain) {
            default -> throw new IncompatibleClassChangeError();
            case TransitMode.AIRPLANE -> "AIRPLANE";
            case TransitMode.BUS -> "BUS";
            case TransitMode.CABLE_CAR -> "CABLE_CAR";
            case TransitMode.COACH -> "COACH";
            case TransitMode.FERRY -> "FERRY";
            case TransitMode.FUNICULAR -> "FUNICULAR";
            case TransitMode.GONDOLA -> "GONDOLA";
            case TransitMode.RAIL -> "RAIL";
            case TransitMode.SUBWAY -> "SUBWAY";
            case TransitMode.TRAM -> "TRAM";
            case TransitMode.TROLLEYBUS -> "TROLLEYBUS";
            case TransitMode.MONORAIL -> "MONORAIL";
        };
    }
}

