/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.mapping;

import com.google.common.collect.Multimap;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opentripplanner.api.model.ApiCurrency;
import org.opentripplanner.api.model.ApiFareComponent;
import org.opentripplanner.api.model.ApiFareProduct;
import org.opentripplanner.api.model.ApiFareQualifier;
import org.opentripplanner.api.model.ApiItineraryFares;
import org.opentripplanner.api.model.ApiLegProducts;
import org.opentripplanner.api.model.ApiMoney;
import org.opentripplanner.ext.fares.model.FareContainer;
import org.opentripplanner.ext.fares.model.FareProduct;
import org.opentripplanner.ext.fares.model.RiderCategory;
import org.opentripplanner.model.plan.Itinerary;
import org.opentripplanner.model.plan.Leg;
import org.opentripplanner.routing.core.FareComponent;
import org.opentripplanner.routing.core.FareType;
import org.opentripplanner.routing.core.ItineraryFares;
import org.opentripplanner.routing.core.Money;

public class FareMapper {
    private final Locale locale;

    public FareMapper(Locale locale) {
        this.locale = locale;
    }

    public ApiItineraryFares mapFare(Itinerary itinerary) {
        ItineraryFares fares = itinerary.getFares();
        Map<String, ApiMoney> apiFare = this.toApiMoneys(fares);
        Map<String, List<ApiFareComponent>> apiComponent = this.toApiFareComponents(fares);
        return new ApiItineraryFares(apiFare, apiComponent, this.toApiFareProducts(fares.getItineraryProducts()), this.toApiLegProducts(itinerary, fares.getLegProducts()));
    }

    private List<ApiLegProducts> toApiLegProducts(Itinerary itinerary, Multimap<Leg, FareProduct> legProducts) {
        if (legProducts.isEmpty()) {
            return null;
        }
        return legProducts.keySet().stream().map(leg -> {
            int index = itinerary.getLegIndex((Leg)leg);
            return new ApiLegProducts(List.of(Integer.valueOf(index)), this.toApiFareProducts(legProducts.get(leg)));
        }).toList();
    }

    private static ApiFareQualifier toApiFareQualifier(@Nullable FareContainer nullable) {
        return Optional.ofNullable(nullable).map(c -> new ApiFareQualifier(c.id(), c.name())).orElse(null);
    }

    private static ApiFareQualifier toApiFareQualifier(@Nullable RiderCategory nullable) {
        return Optional.ofNullable(nullable).map(c -> new ApiFareQualifier(c.id(), c.name())).orElse(null);
    }

    private List<ApiFareProduct> toApiFareProducts(Collection<FareProduct> product) {
        if (product.isEmpty()) {
            return null;
        }
        return product.stream().map(p -> new ApiFareProduct(p.id().toString(), p.name(), this.toApiMoney(p.amount()), FareMapper.toApiFareQualifier(p.category()), FareMapper.toApiFareQualifier(p.container()))).toList();
    }

    private Map<String, List<ApiFareComponent>> toApiFareComponents(ItineraryFares fare) {
        return fare.getTypes().stream().map(key -> {
            List<ApiFareComponent> money = fare.getDetails((FareType)key).stream().map(this::toApiFareComponent).toList();
            return new AbstractMap.SimpleEntry<FareType, List<ApiFareComponent>>((FareType)key, money);
        }).collect(Collectors.toMap(e -> ((FareType)e.getKey()).name(), Map.Entry::getValue));
    }

    private Map<String, ApiMoney> toApiMoneys(ItineraryFares fare) {
        return fare.getTypes().stream().map(key -> {
            ApiMoney money = this.toApiMoney(fare.getFare((FareType)key));
            return new AbstractMap.SimpleEntry<FareType, ApiMoney>((FareType)key, money);
        }).collect(Collectors.toMap(e -> ((FareType)e.getKey()).name(), Map.Entry::getValue));
    }

    private ApiMoney toApiMoney(Money m) {
        Currency c = m.currency();
        return new ApiMoney(m.cents(), new ApiCurrency(c.getCurrencyCode(), c.getDefaultFractionDigits(), c.getCurrencyCode(), c.getSymbol(this.locale)));
    }

    private ApiFareComponent toApiFareComponent(FareComponent m) {
        return new ApiFareComponent(m.fareId(), m.name(), this.toApiMoney(m.price()), m.routes());
    }
}

