/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.api.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.opentripplanner.api.resource.BikeRental;
import org.opentripplanner.api.resource.GraphInspectorTileResource;
import org.opentripplanner.api.resource.PlannerResource;
import org.opentripplanner.api.resource.Routers;
import org.opentripplanner.api.resource.ServerInfo;
import org.opentripplanner.api.resource.UpdaterStatusResource;
import org.opentripplanner.ext.actuator.ActuatorAPI;
import org.opentripplanner.ext.geocoder.GeocoderResource;
import org.opentripplanner.ext.legacygraphqlapi.LegacyGraphQLAPI;
import org.opentripplanner.ext.parkAndRideApi.ParkAndRideResource;
import org.opentripplanner.ext.reportapi.resource.ReportResource;
import org.opentripplanner.ext.transmodelapi.TransmodelAPI;
import org.opentripplanner.ext.traveltime.TravelTimeResource;
import org.opentripplanner.ext.vectortiles.VectorTilesResource;
import org.opentripplanner.index.IndexAPI;
import org.opentripplanner.util.OTPFeature;

public class APIEndpoints {
    private final List<Class<?>> resources = new ArrayList();

    private APIEndpoints() {
        this.add(Routers.class);
        this.add(PlannerResource.class);
        this.add(IndexAPI.class);
        this.addIfEnabled(OTPFeature.APIBikeRental, BikeRental.class);
        this.addIfEnabled(OTPFeature.APIServerInfo, ServerInfo.class);
        this.addIfEnabled(OTPFeature.APIGraphInspectorTile, GraphInspectorTileResource.class);
        this.addIfEnabled(OTPFeature.APIUpdaterStatus, UpdaterStatusResource.class);
        this.addIfEnabled(OTPFeature.ActuatorAPI, ActuatorAPI.class);
        this.addIfEnabled(OTPFeature.ReportApi, ReportResource.class);
        this.addIfEnabled(OTPFeature.SandboxAPITransmodelApi, TransmodelAPI.class);
        this.addIfEnabled(OTPFeature.SandboxAPILegacyGraphQLApi, LegacyGraphQLAPI.class);
        this.addIfEnabled(OTPFeature.SandboxAPIMapboxVectorTilesApi, VectorTilesResource.class);
        this.addIfEnabled(OTPFeature.SandboxAPIParkAndRideApi, ParkAndRideResource.class);
        this.addIfEnabled(OTPFeature.SandboxAPIGeocoder, GeocoderResource.class);
        this.addIfEnabled(OTPFeature.SandboxAPITravelTime, TravelTimeResource.class);
    }

    public static Collection<? extends Class<?>> listAPIEndpoints() {
        return Collections.unmodifiableCollection(new APIEndpoints().resources);
    }

    private void addIfEnabled(OTPFeature apiFeature, Class<?> resource) {
        if (apiFeature.isOn()) {
            this.add(resource);
        }
    }

    private void add(Class<?> resource) {
        this.resources.add(resource);
    }
}

