/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.visualizer;

import org.opentripplanner.routing.algorithm.astar.TraverseVisitor;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.visualizer.ShowGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualTraverseVisitor
implements TraverseVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(VisualTraverseVisitor.class);
    private ShowGraph gui;
    private final int SLEEP_AFTER = 50;
    private final int SLEEP_LEN = 2;
    private int sleepAfter = 50;

    public VisualTraverseVisitor(ShowGraph gui) {
        this.gui = gui;
    }

    @Override
    public void visitEdge(Edge edge, State state) {
        this.gui.enqueueHighlightedEdge(edge);
    }

    @Override
    public void visitVertex(State state) {
        if (--this.sleepAfter <= 0) {
            this.sleepAfter = 50;
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException e) {
                LOG.warn("interrupted", (Throwable)e);
            }
        }
        this.gui.addNewSPTEdge(state);
    }

    @Override
    public void visitEnqueue(State state) {
    }
}

