/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.visualizer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.locationtech.jts.geom.Coordinate;
import org.opentripplanner.graph_builder.DataImportIssue;
import org.opentripplanner.routing.algorithm.astar.TraverseVisitor;
import org.opentripplanner.routing.api.request.RoutingRequest;
import org.opentripplanner.routing.core.BicycleOptimizeType;
import org.opentripplanner.routing.core.State;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.edgetype.StreetEdge;
import org.opentripplanner.routing.graph.Edge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.graph.Vertex;
import org.opentripplanner.routing.impl.GraphPathFinder;
import org.opentripplanner.routing.spt.DominanceFunction;
import org.opentripplanner.routing.spt.GraphPath;
import org.opentripplanner.routing.spt.ShortestPathTree;
import org.opentripplanner.routing.vertextype.IntersectionVertex;
import org.opentripplanner.standalone.server.Router;
import org.opentripplanner.visualizer.DisplayVertex;
import org.opentripplanner.visualizer.EdgeListModel;
import org.opentripplanner.visualizer.ExitListener;
import org.opentripplanner.visualizer.ShowGraph;
import org.opentripplanner.visualizer.VertexList;
import org.opentripplanner.visualizer.VertexSelectionListener;
import org.opentripplanner.visualizer.VisualTraverseVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphVisualizer
extends JFrame
implements VertexSelectionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(GraphVisualizer.class);
    private JPanel leftPanel;
    private ShowGraph showGraph;
    public TraverseVisitor traverseVisitor;
    public JList<DisplayVertex> nearbyVertices;
    private JList<Edge> outgoingEdges;
    private JList<Edge> incomingEdges;
    private JTextField sourceVertex;
    private JTextField sinkVertex;
    private JCheckBox walkCheckBox;
    private JCheckBox bikeCheckBox;
    private JCheckBox trainCheckBox;
    private JCheckBox busCheckBox;
    private JCheckBox ferryCheckBox;
    private JCheckBox transitCheckBox;
    private JCheckBox carCheckBox;
    private JTextField searchDate;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private JTextField boardingPenaltyField;
    private DefaultListModel<DataImportIssue> issueMatchesModel;
    private JList<DataImportIssue> issueMatches;
    private DefaultListModel<String> metadataModel;
    private HashSet<Vertex> closed;
    private Vertex tracingVertex;
    private HashSet<Vertex> open;
    private HashSet<Vertex> seen;
    private JList<String> metadataList;
    private final Router router;
    private final Graph graph;
    private JRadioButton opQuick;
    private JRadioButton opSafe;
    private JRadioButton opFlat;
    private JRadioButton opGreenways;
    private ButtonGroup optimizeTypeGrp;
    private JTextField maxWalkField;
    private JTextField walkSpeed;
    private JTextField bikeSpeed;
    private JTextField heuristicWeight;
    private JCheckBox softWalkLimiting;
    private JTextField softWalkPenalty;
    private JTextField softWalkOverageRate;
    private JCheckBox arriveByCheckBox;
    private JLabel searchTimeElapsedLabel;
    private JCheckBox dontUseGraphicalCallbackCheckBox;
    private JTextField nPaths;
    private JList<PathPrinter> pathsList;
    private JList<State> pathStates;
    private JCheckBox showTransitCheckbox;
    private JCheckBox showStreetsCheckbox;
    private JCheckBox showMultistateVerticesCheckbox;
    private JCheckBox showHighlightedCheckbox;
    private JCheckBox showSPTCheckbox;
    private ShortestPathTree spt;
    private JTextField sptFlattening;
    private JTextField sptThickness;
    private JPopupMenu popup;
    private GraphPath firstComparePath;
    private GraphPath secondComparePath;
    private JList<State> firstComparePathStates;
    private JList<State> secondComparePathStates;
    private JList<String> secondStateData;
    private JList<String> firstStateData;
    protected State lastStateClicked = null;
    private JCheckBox longDistanceModeCheckbox;

    public GraphVisualizer(Router router) {
        LOG.info("Starting up graph visualizer...");
        this.setTitle("GraphVisualizer");
        this.router = router;
        this.graph = router.graph;
        this.init();
    }

    public void run() {
        this.setVisible(true);
    }

    public void init() {
        final JTabbedPane tabbedPane = new JTabbedPane();
        final Container mainTab = this.makeMainTab();
        JComponent prefsPanel = this.makePrefsPanel();
        Container diffTab = this.makeDiffTab();
        tabbedPane.addTab("Main", null, mainTab, "Pretty much everything");
        tabbedPane.addTab("Prefs", null, prefsPanel, "Routing preferences");
        tabbedPane.addTab("Diff", null, diffTab, "multistate path diffs");
        this.add(tabbedPane);
        tabbedPane.setTabLayoutPolicy(1);
        this.showGraph.init();
        this.addWindowListener(new ExitListener());
        this.pack();
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (tabbedPane.getSelectedComponent().equals(mainTab)) {
                    GraphVisualizer.this.showGraph.loop();
                } else {
                    GraphVisualizer.this.showGraph.noLoop();
                }
            }
        });
    }

    private Container makeDiffTab() {
        JPanel pane = new JPanel();
        pane.setLayout(new GridLayout(0, 2));
        this.firstStateData = new JList();
        this.secondStateData = new JList();
        this.firstComparePathStates = new JList();
        JScrollPane stScrollPane = new JScrollPane(this.firstComparePathStates);
        stScrollPane.setHorizontalScrollBarPolicy(32);
        pane.add(stScrollPane);
        this.firstComparePathStates.addListSelectionListener(new ComparePathStatesClickListener(this.firstStateData));
        this.secondComparePathStates = new JList();
        stScrollPane = new JScrollPane(this.secondComparePathStates);
        stScrollPane.setHorizontalScrollBarPolicy(32);
        pane.add(stScrollPane);
        this.secondComparePathStates.addListSelectionListener(new ComparePathStatesClickListener(this.secondStateData));
        stScrollPane = new JScrollPane(this.firstStateData);
        stScrollPane.setHorizontalScrollBarPolicy(32);
        pane.add(stScrollPane);
        stScrollPane = new JScrollPane(this.secondStateData);
        stScrollPane.setHorizontalScrollBarPolicy(32);
        pane.add(stScrollPane);
        JButton dominateButton = new JButton();
        dominateButton.setText("dominates");
        dominateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                State s1 = GraphVisualizer.this.firstComparePathStates.getSelectedValue();
                State s2 = GraphVisualizer.this.secondComparePathStates.getSelectedValue();
                DominanceFunction.Pareto pareto = new DominanceFunction.Pareto();
                System.out.println("s1 dominates s2:" + pareto.betterOrEqualAndComparable(s1, s2));
                System.out.println("s2 dominates s1:" + pareto.betterOrEqualAndComparable(s2, s1));
            }
        });
        pane.add(dominateButton);
        JButton traverseButton = new JButton();
        traverseButton.setText("traverse");
        traverseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraphVisualizer.this.lastStateClicked == null) {
                    return;
                }
                Edge backEdge = GraphVisualizer.this.lastStateClicked.getBackEdge();
                State backState = GraphVisualizer.this.lastStateClicked.getBackState();
                backEdge.traverse(backState);
            }
        });
        pane.add(traverseButton);
        return pane;
    }

    private Container makeMainTab() {
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        this.showGraph = new ShowGraph(this, this.getGraph());
        pane.add((Component)((Object)this.showGraph), "Center");
        this.traverseVisitor = new VisualTraverseVisitor(this.showGraph);
        this.leftPanel = new JPanel();
        this.leftPanel.setLayout(new BorderLayout());
        pane.add((Component)this.leftPanel, "Before");
        this.initRoutingSubpanel();
        this.initVertexInfoSubpanel();
        this.initControlButtons();
        this.initRightPanel(pane);
        return pane;
    }

    private JComponent makePrefsPanel() {
        JPanel pane = new JPanel();
        pane.setLayout(new GridLayout(0, 2));
        this.walkCheckBox = new JCheckBox("walk");
        this.walkCheckBox.setSelected(true);
        pane.add(this.walkCheckBox);
        this.bikeCheckBox = new JCheckBox("bike");
        pane.add(this.bikeCheckBox);
        this.trainCheckBox = new JCheckBox("trainish");
        pane.add(this.trainCheckBox);
        this.busCheckBox = new JCheckBox("busish");
        pane.add(this.busCheckBox);
        this.ferryCheckBox = new JCheckBox("ferry");
        pane.add(this.ferryCheckBox);
        this.transitCheckBox = new JCheckBox("transit");
        this.transitCheckBox.setSelected(true);
        pane.add(this.transitCheckBox);
        this.carCheckBox = new JCheckBox("car");
        pane.add(this.carCheckBox);
        JLabel dummyLabel = new JLabel("");
        pane.add(dummyLabel);
        JLabel arriveByLabel = new JLabel("Arrive by?:");
        pane.add(arriveByLabel);
        this.arriveByCheckBox = new JCheckBox("arrive by");
        pane.add(this.arriveByCheckBox);
        JLabel boardPenaltyLabel = new JLabel("Boarding penalty (min):");
        pane.add(boardPenaltyLabel);
        this.boardingPenaltyField = new JTextField("5");
        pane.add(this.boardingPenaltyField);
        JLabel maxWalkLabel = new JLabel("Maximum walk (meters):");
        pane.add(maxWalkLabel);
        this.maxWalkField = new JTextField("5000");
        pane.add(this.maxWalkField);
        JLabel walkSpeedLabel = new JLabel("Walk speed (m/s):");
        pane.add(walkSpeedLabel);
        this.walkSpeed = new JTextField("1.33");
        pane.add(this.walkSpeed);
        JLabel bikeSpeedLabel = new JLabel("Bike speed (m/s):");
        pane.add(bikeSpeedLabel);
        this.bikeSpeed = new JTextField("5.0");
        pane.add(this.bikeSpeed);
        JLabel heuristicWeightLabel = new JLabel("Heuristic weight:");
        pane.add(heuristicWeightLabel);
        this.heuristicWeight = new JTextField("1.0");
        pane.add(this.heuristicWeight);
        JLabel softWalkLimitLabel = new JLabel("Soft walk-limit?:");
        pane.add(softWalkLimitLabel);
        this.softWalkLimiting = new JCheckBox("soft walk-limiting");
        pane.add(this.softWalkLimiting);
        JLabel softWalkLimitPenaltyLabel = new JLabel("Soft walk-limiting penalty:");
        pane.add(softWalkLimitPenaltyLabel);
        this.softWalkPenalty = new JTextField("60.0");
        pane.add(this.softWalkPenalty);
        JLabel softWalkLimitOverageLabel = new JLabel("Soft walk-limiting overage:");
        pane.add(softWalkLimitOverageLabel);
        this.softWalkOverageRate = new JTextField("5.0");
        pane.add(this.softWalkOverageRate);
        JLabel nPathsLabel = new JLabel("nPaths:");
        pane.add(nPathsLabel);
        this.nPaths = new JTextField("1");
        pane.add(this.nPaths);
        ItemListener onChangeVizPrefs = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GraphVisualizer.this.showGraph.setShowTransit(GraphVisualizer.this.showTransitCheckbox.isSelected());
                GraphVisualizer.this.showGraph.setShowStreets(GraphVisualizer.this.showStreetsCheckbox.isSelected());
                GraphVisualizer.this.showGraph.setShowMultistateVertices(GraphVisualizer.this.showMultistateVerticesCheckbox.isSelected());
                GraphVisualizer.this.showGraph.setShowHightlights(GraphVisualizer.this.showHighlightedCheckbox.isSelected());
                GraphVisualizer.this.showGraph.setShowSPT(GraphVisualizer.this.showSPTCheckbox.isSelected());
                GraphVisualizer.this.showGraph.redraw();
            }
        };
        this.showTransitCheckbox = new JCheckBox("show transit");
        this.showTransitCheckbox.setSelected(true);
        this.showTransitCheckbox.addItemListener(onChangeVizPrefs);
        pane.add(this.showTransitCheckbox);
        this.showStreetsCheckbox = new JCheckBox("show streets");
        this.showStreetsCheckbox.setSelected(true);
        this.showStreetsCheckbox.addItemListener(onChangeVizPrefs);
        pane.add(this.showStreetsCheckbox);
        this.showHighlightedCheckbox = new JCheckBox("show highlighted");
        this.showHighlightedCheckbox.setSelected(true);
        this.showHighlightedCheckbox.addItemListener(onChangeVizPrefs);
        pane.add(this.showHighlightedCheckbox);
        this.showSPTCheckbox = new JCheckBox("show SPT");
        this.showSPTCheckbox.setSelected(true);
        this.showSPTCheckbox.addItemListener(onChangeVizPrefs);
        pane.add(this.showSPTCheckbox);
        this.showMultistateVerticesCheckbox = new JCheckBox("show multistate vertices");
        this.showMultistateVerticesCheckbox.setSelected(true);
        this.showMultistateVerticesCheckbox.addItemListener(onChangeVizPrefs);
        pane.add(this.showMultistateVerticesCheckbox);
        JLabel dummyLabel2 = new JLabel("");
        pane.add(dummyLabel2);
        JLabel sptFlatteningLabel = new JLabel("SPT flattening:");
        pane.add(sptFlatteningLabel);
        this.sptFlattening = new JTextField("0.3");
        pane.add(this.sptFlattening);
        JLabel sptThicknessLabel = new JLabel("SPT thickness:");
        pane.add(sptThicknessLabel);
        this.sptThickness = new JTextField("0.1");
        pane.add(this.sptThickness);
        JLabel optimizeTypeLabel = new JLabel("Optimize type:");
        pane.add(optimizeTypeLabel);
        this.opQuick = new JRadioButton("Quick");
        this.opQuick.setSelected(true);
        this.opSafe = new JRadioButton("Safe");
        this.opFlat = new JRadioButton("Flat");
        this.opGreenways = new JRadioButton("Greenways");
        this.optimizeTypeGrp = new ButtonGroup();
        this.optimizeTypeGrp.add(this.opQuick);
        this.optimizeTypeGrp.add(this.opSafe);
        this.optimizeTypeGrp.add(this.opFlat);
        this.optimizeTypeGrp.add(this.opGreenways);
        JPanel optimizeTypePane = new JPanel();
        optimizeTypePane.add(this.opQuick);
        optimizeTypePane.add(this.opSafe);
        optimizeTypePane.add(this.opFlat);
        optimizeTypePane.add(this.opGreenways);
        pane.add(optimizeTypePane);
        return pane;
    }

    BicycleOptimizeType getSelectedOptimizeType() {
        if (this.opQuick.isSelected()) {
            return BicycleOptimizeType.QUICK;
        }
        if (this.opSafe.isSelected()) {
            return BicycleOptimizeType.SAFE;
        }
        if (this.opFlat.isSelected()) {
            return BicycleOptimizeType.FLAT;
        }
        if (this.opGreenways.isSelected()) {
            return BicycleOptimizeType.GREENWAYS;
        }
        return BicycleOptimizeType.QUICK;
    }

    protected JComponent makeTextPanel(String text) {
        JPanel panel = new JPanel(false);
        JLabel filler = new JLabel(text);
        filler.setHorizontalAlignment(0);
        panel.setLayout(new GridLayout(1, 1));
        panel.add(filler);
        return panel;
    }

    private void initRightPanel(Container pane) {
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BorderLayout());
        pane.add((Component)rightPanel, "After");
        JTabbedPane rightPanelTabs = new JTabbedPane();
        rightPanel.add((Component)rightPanelTabs, "After");
        this.pathStates = new JList();
        JScrollPane stScrollPane = new JScrollPane(this.pathStates);
        stScrollPane.setHorizontalScrollBarPolicy(32);
        rightPanelTabs.addTab("path states", stScrollPane);
        this.pathStates.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GraphVisualizer.this.outgoingEdges.clearSelection();
                GraphVisualizer.this.incomingEdges.clearSelection();
                JList theList = (JList)e.getSource();
                State st = (State)theList.getSelectedValue();
                Edge edge = st.getBackEdge();
                GraphVisualizer.this.reactToEdgeSelection(edge, false);
            }
        });
        this.metadataList = new JList();
        this.metadataModel = new DefaultListModel();
        this.metadataList.setModel(this.metadataModel);
        JScrollPane mdScrollPane = new JScrollPane(this.metadataList);
        mdScrollPane.setHorizontalScrollBarPolicy(32);
        rightPanelTabs.addTab("metadata", mdScrollPane);
        this.issueMatches = new JList();
        this.issueMatches.addListSelectionListener(e -> {
            JList theList = (JList)e.getSource();
            DataImportIssue issue = (DataImportIssue)theList.getSelectedValue();
            if (issue == null) {
                return;
            }
            this.showGraph.drawIssue(issue);
        });
        this.issueMatchesModel = new DefaultListModel();
        this.issueMatches.setModel(this.issueMatchesModel);
        JScrollPane imScrollPane = new JScrollPane(this.issueMatches);
        imScrollPane.setHorizontalScrollBarPolicy(32);
        rightPanelTabs.addTab("issues", imScrollPane);
        Dimension size = new Dimension(200, 1600);
        imScrollPane.setMaximumSize(size);
        imScrollPane.setPreferredSize(size);
        stScrollPane.setMaximumSize(size);
        stScrollPane.setPreferredSize(size);
        mdScrollPane.setMaximumSize(size);
        mdScrollPane.setPreferredSize(size);
        rightPanelTabs.setMaximumSize(size);
        rightPanel.setMaximumSize(size);
    }

    private void initControlButtons() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(0, 3));
        this.leftPanel.add((Component)buttonPanel, "Last");
        JButton zoomDefaultButton = new JButton("Zoom to default");
        zoomDefaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphVisualizer.this.showGraph.zoomToDefault();
            }
        });
        buttonPanel.add(zoomDefaultButton);
        final GraphVisualizer frame = this;
        JButton zoomToNodeButton = new JButton("Zoom to node");
        zoomToNodeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String nodeName = JOptionPane.showInputDialog(frame, "Node id", -1);
                Vertex v = GraphVisualizer.this.getGraph().getVertex(nodeName);
                if (v == null) {
                    System.out.println("no such node " + nodeName);
                } else {
                    GraphVisualizer.this.showGraph.zoomToVertex(v);
                }
            }
        });
        buttonPanel.add(zoomToNodeButton);
        JButton zoomToLocationButton = new JButton("Zoom to location");
        zoomToLocationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String result = JOptionPane.showInputDialog("Enter the location (lat lon)");
                if (result == null || result.length() == 0) {
                    return;
                }
                String[] tokens = result.split("[\\s,]+");
                double lat = Double.parseDouble(tokens[0]);
                double lon = Double.parseDouble(tokens[1]);
                Coordinate c = new Coordinate(lon, lat);
                GraphVisualizer.this.showGraph.zoomToLocation(c);
            }
        });
        buttonPanel.add(zoomToLocationButton);
        JButton zoomOutButton = new JButton("Zoom out");
        zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphVisualizer.this.showGraph.zoomOut();
            }
        });
        buttonPanel.add(zoomOutButton);
        JButton routeButton2 = new JButton("Route");
        routeButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String from = GraphVisualizer.this.sourceVertex.getText();
                String to = GraphVisualizer.this.sinkVertex.getText();
                GraphVisualizer.this.route(from, to);
            }
        });
        buttonPanel.add(routeButton2);
        JButton findButton = new JButton("Find node");
        findButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String nodeName = JOptionPane.showInputDialog(frame, "Node id", -1);
                Vertex v = GraphVisualizer.this.getGraph().getVertex(nodeName);
                if (v == null) {
                    System.out.println("no such node " + nodeName);
                } else {
                    GraphVisualizer.this.showGraph.highlightVertex(v);
                    ArrayList<Vertex> l = new ArrayList<Vertex>();
                    l.add(v);
                    GraphVisualizer.this.verticesSelected(l);
                }
            }
        });
        buttonPanel.add(findButton);
        JButton findEdgeButton = new JButton("Find edge");
        findEdgeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String edgeName = JOptionPane.showInputDialog(frame, "Edge name like", -1);
                for (Vertex gv : GraphVisualizer.this.getGraph().getVertices()) {
                    for (Edge edge : gv.getOutgoing()) {
                        if (edge.getDefaultName() == null || !edge.getDefaultName().contains(edgeName)) continue;
                        GraphVisualizer.this.showGraph.highlightVertex(gv);
                        ArrayList<Vertex> l = new ArrayList<Vertex>();
                        l.add(gv);
                        GraphVisualizer.this.verticesSelected(l);
                    }
                }
            }
        });
        buttonPanel.add(findEdgeButton);
        JButton checkButton = new JButton("Check graph");
        checkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphVisualizer.this.checkGraph();
            }
        });
        buttonPanel.add(checkButton);
        JButton traceButton = new JButton("Trace");
        traceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphVisualizer.this.trace();
            }
        });
        buttonPanel.add(traceButton);
        JButton findEdgeByIdButton = new JButton("Find edge ID");
        findEdgeByIdButton.addActionListener(e -> {
            throw new UnsupportedOperationException("Edges no longer have integer IDs.");
        });
        buttonPanel.add(findEdgeByIdButton);
        JButton snapButton = new JButton("Snap location");
        snapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LOG.error("StreetIndex.getClosestPointOnStreet no longer exists.");
            }
        });
        buttonPanel.add(snapButton);
    }

    private void getMetadata(Object selected) {
        for (Class<?> c = selected.getClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            this.metadataModel.addElement("Class:" + c);
            Field[] fields = c.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                int modifiers = field.getModifiers();
                if ((modifiers & 8) != 0) continue;
                field.setAccessible(true);
                String name = field.getName();
                Object value = "(unknown -- see console for stack trace)";
                try {
                    value = "" + field.get(selected);
                }
                catch (IllegalArgumentException e1) {
                    LOG.error("IllegalArgumentException", (Throwable)e1);
                }
                catch (IllegalAccessException e1) {
                    LOG.error("IllegalAccessException", (Throwable)e1);
                }
                this.metadataModel.addElement(name + ": " + (String)value);
            }
        }
    }

    private void reactToEdgeSelection(Edge selected, boolean outgoing) {
        Vertex fromv;
        if (selected == null) {
            return;
        }
        this.showGraph.highlightEdge(selected);
        if (selected instanceof StreetEdge) {
            ArrayList<Vertex> vertices = new ArrayList<Vertex>();
            ArrayList<Edge> edges = new ArrayList<Edge>();
            Vertex tov = selected.getToVertex();
            for (Edge og : tov.getOutgoing()) {
                if (!(og instanceof StreetEdge)) continue;
                edges.add(og);
                vertices.add(og.getToVertex());
                break;
            }
            fromv = selected.getFromVertex();
            for (Edge ic : fromv.getIncoming()) {
                if (!(ic instanceof StreetEdge)) continue;
                edges.add(ic);
                vertices.add(ic.getFromVertex());
                break;
            }
            this.showGraph.setHighlightedEdges(edges);
        }
        VertexList nearbyModel = (VertexList)this.nearbyVertices.getModel();
        List<Vertex> vertices = nearbyModel.selected;
        Vertex v = outgoing ? selected.getToVertex() : selected.getFromVertex();
        if (!vertices.contains(v)) {
            vertices.add(v);
            nearbyModel = new VertexList(vertices);
            this.nearbyVertices.setModel(nearbyModel);
        }
        this.metadataModel.clear();
        this.getMetadata(selected);
        fromv = selected.getFromVertex();
        this.getMetadata(fromv);
        if (selected instanceof StreetEdge) {
            // empty if block
        }
        this.metadataList.revalidate();
    }

    private void initVertexInfoSubpanel() {
        JPanel vertexDataPanel = new JPanel();
        vertexDataPanel.setLayout(new BoxLayout(vertexDataPanel, 3));
        vertexDataPanel.setPreferredSize(new Dimension(300, 600));
        this.leftPanel.add((Component)vertexDataPanel, "Center");
        JLabel nvLabel = new JLabel("Vertices");
        vertexDataPanel.add(nvLabel);
        this.nearbyVertices = new JList();
        this.nearbyVertices.setVisibleRowCount(4);
        JScrollPane nvScrollPane = new JScrollPane(this.nearbyVertices);
        vertexDataPanel.add(nvScrollPane);
        this.nearbyVertices.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                GraphVisualizer.this.outgoingEdges.removeAll();
                GraphVisualizer.this.incomingEdges.removeAll();
                DisplayVertex selected = GraphVisualizer.this.nearbyVertices.getSelectedValue();
                if (selected != null) {
                    Vertex nowSelected = selected.vertex;
                    GraphVisualizer.this.showGraph.highlightVertex(nowSelected);
                    GraphVisualizer.this.outgoingEdges.setModel(new EdgeListModel(nowSelected.getOutgoing()));
                    GraphVisualizer.this.incomingEdges.setModel(new EdgeListModel(nowSelected.getIncoming()));
                }
            }
        });
        ListSelectionListener edgeChanged = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                JList edgeList = (JList)e.getSource();
                Edge selected = (Edge)edgeList.getSelectedValue();
                boolean outgoing = edgeList == GraphVisualizer.this.outgoingEdges;
                GraphVisualizer.this.reactToEdgeSelection(selected, outgoing);
            }
        };
        JLabel ogeLabel = new JLabel("Outgoing edges");
        vertexDataPanel.add(ogeLabel);
        this.outgoingEdges = new JList();
        this.outgoingEdges.setVisibleRowCount(4);
        JScrollPane ogeScrollPane = new JScrollPane(this.outgoingEdges);
        vertexDataPanel.add(ogeScrollPane);
        this.outgoingEdges.addListSelectionListener(edgeChanged);
        JLabel iceLabel = new JLabel("Incoming edges");
        vertexDataPanel.add(iceLabel);
        this.incomingEdges = new JList();
        JScrollPane iceScrollPane = new JScrollPane(this.incomingEdges);
        vertexDataPanel.add(iceScrollPane);
        this.incomingEdges.addListSelectionListener(edgeChanged);
        JLabel pathsLabel = new JLabel("Paths");
        vertexDataPanel.add(pathsLabel);
        this.pathsList = new JList();
        this.popup = new JPopupMenu();
        JMenuItem compareMenuItem = new JMenuItem("compare");
        compareMenuItem.addActionListener(new OnPopupMenuClickListener());
        this.popup.add(compareMenuItem);
        this.pathsList.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    JList list = (JList)e.getSource();
                    int row = list.locationToIndex(e.getPoint());
                    list.setSelectedIndex(row);
                    GraphVisualizer.this.popup.show(list, e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.pathsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                PathPrinter pp = GraphVisualizer.this.pathsList.getSelectedValue();
                if (pp == null) {
                    return;
                }
                GraphPath path = pp.gp;
                DefaultListModel<State> pathModel = new DefaultListModel<State>();
                for (State st : path.states) {
                    pathModel.addElement(st);
                }
                GraphVisualizer.this.pathStates.setModel(pathModel);
                GraphVisualizer.this.showGraph.highlightGraphPath(path);
            }
        });
        JScrollPane pathsScrollPane = new JScrollPane(this.pathsList);
        vertexDataPanel.add(pathsScrollPane);
    }

    private void initRoutingSubpanel() {
        JPanel routingPanel = new JPanel();
        routingPanel.setLayout(new GridLayout(0, 2));
        this.leftPanel.add((Component)routingPanel, "North");
        JButton setSourceVertexButton = new JButton("set source");
        setSourceVertexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayVertex selected = GraphVisualizer.this.nearbyVertices.getSelectedValue();
                if (selected != null) {
                    GraphVisualizer.this.sourceVertex.setText(((Object)selected).toString());
                }
            }
        });
        routingPanel.add(setSourceVertexButton);
        this.sourceVertex = new JTextField();
        routingPanel.add(this.sourceVertex);
        JButton setSinkVertexButton = new JButton("set sink");
        setSinkVertexButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayVertex selected = GraphVisualizer.this.nearbyVertices.getSelectedValue();
                if (selected != null) {
                    GraphVisualizer.this.sinkVertex.setText(((Object)selected).toString());
                }
            }
        });
        routingPanel.add(setSinkVertexButton);
        this.sinkVertex = new JTextField();
        routingPanel.add(this.sinkVertex);
        JButton resetSearchDateButton = new JButton("now ->");
        resetSearchDateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphVisualizer.this.searchDate.setText(GraphVisualizer.this.dateFormat.format(new Date()));
            }
        });
        routingPanel.add(resetSearchDateButton);
        this.searchDate = new JTextField();
        this.searchDate.setText(this.dateFormat.format(new Date()));
        routingPanel.add(this.searchDate);
        JButton routeButton = new JButton("path search");
        routeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String from = GraphVisualizer.this.sourceVertex.getText();
                String to = GraphVisualizer.this.sinkVertex.getText();
                GraphVisualizer.this.route(from, to);
            }
        });
        routingPanel.add(routeButton);
        JButton continueButton = new JButton("continue");
        continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        routingPanel.add(continueButton);
        JButton clearRouteButton = new JButton("clear path");
        clearRouteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraphVisualizer.this.showGraph.highlightGraphPath(null);
                GraphVisualizer.this.showGraph.clearHighlights();
                GraphVisualizer.this.showGraph.resetSPT();
            }
        });
        routingPanel.add(clearRouteButton);
        this.searchTimeElapsedLabel = new JLabel("search time elapsed:");
        routingPanel.add(this.searchTimeElapsedLabel);
        this.dontUseGraphicalCallbackCheckBox = new JCheckBox("no graphics");
        routingPanel.add(this.dontUseGraphicalCallbackCheckBox);
    }

    protected void trace() {
        DisplayVertex selected = this.nearbyVertices.getSelectedValue();
        if (selected == null) {
            return;
        }
        Vertex v = selected.vertex;
        if (this.tracingVertex != v) {
            this.tracingVertex = v;
            this.closed = new HashSet();
            this.open = new HashSet();
            this.open.add(v);
            this.seen = new HashSet();
        }
        HashSet<Vertex> newOpen = new HashSet<Vertex>();
        for (Vertex v2 : this.open) {
            this.closed.add(v2);
            for (Edge e : v2.getOutgoing()) {
                Vertex target = e.getToVertex();
                if (this.closed.contains(target)) continue;
                newOpen.add(target);
            }
        }
        this.seen.addAll(newOpen);
        this.open = newOpen;
        this.showGraph.setHighlightedVertices(this.seen);
    }

    protected void traceOld() {
        HashSet<Vertex> seenVertices = new HashSet<Vertex>();
        DisplayVertex selected = this.nearbyVertices.getSelectedValue();
        if (selected == null) {
            System.out.println("no vertex selected");
            return;
        }
        Vertex v = selected.vertex;
        System.out.println("initial vertex: " + v);
        LinkedList<Vertex> toExplore = new LinkedList<Vertex>();
        toExplore.add(v);
        seenVertices.add(v);
        while (!toExplore.isEmpty()) {
            Vertex src = (Vertex)toExplore.poll();
            for (Edge e : src.getOutgoing()) {
                Vertex tov = e.getToVertex();
                if (seenVertices.contains(tov)) continue;
                seenVertices.add(tov);
                toExplore.add(tov);
            }
        }
        this.showGraph.setHighlightedVertices(seenVertices);
    }

    protected void checkGraph() {
        HashSet<Vertex> seenVertices = new HashSet<Vertex>();
        Collection<Vertex> allVertices = this.getGraph().getVertices();
        Vertex v = allVertices.iterator().next();
        System.out.println("initial vertex: " + v);
        LinkedList<Vertex> toExplore = new LinkedList<Vertex>();
        toExplore.add(v);
        seenVertices.add(v);
        while (!toExplore.isEmpty()) {
            Vertex src = (Vertex)toExplore.poll();
            for (Edge e : src.getOutgoing()) {
                Vertex tov = e.getToVertex();
                if (seenVertices.contains(tov)) continue;
                seenVertices.add(tov);
                toExplore.add(tov);
            }
        }
        System.out.println("After investigation, visited " + seenVertices.size() + " of " + allVertices.size());
        for (Vertex u : allVertices) {
            if (seenVertices.contains(u)) continue;
            System.out.println("unvisited vertex" + u);
            break;
        }
    }

    protected void route(String from, String to) {
        Date when;
        try {
            when = this.dateFormat.parse(this.searchDate.getText());
        }
        catch (ParseException e) {
            this.searchDate.setText("Format: " + this.dateFormat.toPattern());
            return;
        }
        TraverseModeSet modeSet = new TraverseModeSet(new TraverseMode[0]);
        modeSet.setWalk(this.walkCheckBox.isSelected());
        modeSet.setBicycle(this.bikeCheckBox.isSelected());
        modeSet.setFerry(this.ferryCheckBox.isSelected());
        modeSet.setRail(this.trainCheckBox.isSelected());
        modeSet.setTram(this.trainCheckBox.isSelected());
        modeSet.setSubway(this.trainCheckBox.isSelected());
        modeSet.setFunicular(this.trainCheckBox.isSelected());
        modeSet.setGondola(this.trainCheckBox.isSelected());
        modeSet.setBus(this.busCheckBox.isSelected());
        modeSet.setCableCar(this.busCheckBox.isSelected());
        modeSet.setCar(this.carCheckBox.isSelected());
        if (this.transitCheckBox.isSelected()) {
            modeSet.setTransit(true);
        }
        RoutingRequest options = new RoutingRequest(modeSet);
        options.setArriveBy(this.arriveByCheckBox.isSelected());
        options.setWalkBoardCost(Integer.parseInt(this.boardingPenaltyField.getText()) * 60);
        options.setBikeBoardCost(Integer.parseInt(this.boardingPenaltyField.getText()) * 60 * 2);
        options.setBicycleOptimizeType(this.getSelectedOptimizeType());
        options.setDateTime(when.toInstant());
        options.setFromString(from);
        options.setToString(to);
        options.walkSpeed = Float.parseFloat(this.walkSpeed.getText());
        options.bikeSpeed = Float.parseFloat(this.bikeSpeed.getText());
        options.numItineraries = 1;
        System.out.println("--------");
        System.out.println("Path from " + from + " to " + to + " at " + when);
        System.out.println("\tModes: " + modeSet);
        System.out.println("\tOptions: " + options);
        options.numItineraries = Integer.parseInt(this.nPaths.getText());
        GraphPathFinder finder = new GraphPathFinder(this.router);
        long t0 = System.currentTimeMillis();
        List<GraphPath> paths = finder.graphPathFinderEntryPoint(options);
        long dt = System.currentTimeMillis() - t0;
        this.searchTimeElapsedLabel.setText("search time elapsed: " + dt + "ms");
        if (paths == null) {
            System.out.println("no path");
            this.showGraph.highlightGraphPath(null);
            return;
        }
        this.showGraph.simpleSPT.setWeights();
        this.showPathsInPanel(paths);
        this.showGraph.setSPTFlattening(Float.parseFloat(this.sptFlattening.getText()));
        this.showGraph.setSPTThickness(Float.parseFloat(this.sptThickness.getText()));
        this.showGraph.redraw();
        options.cleanup();
    }

    private void showPathsInPanel(List<GraphPath> paths) {
        DefaultListModel<PathPrinter> data = new DefaultListModel<PathPrinter>();
        for (GraphPath gp : paths) {
            data.addElement(new PathPrinter(gp));
        }
        this.pathsList.setModel(data);
    }

    @Override
    public void verticesSelected(List<Vertex> selected) {
        Collections.sort(selected, new Comparator<Vertex>(){

            @Override
            public int compare(Vertex arg0, Vertex arg1) {
                return arg0.getLabel().compareTo(arg1.getLabel());
            }
        });
        VertexList data = new VertexList(selected);
        this.nearbyVertices.setModel(data);
        Vertex target = null;
        for (Vertex vv : selected) {
            if (!(vv instanceof IntersectionVertex)) continue;
            target = vv;
            break;
        }
        if (target != null && this.spt != null) {
            List<GraphPath> paths = this.spt.getPaths(target, true);
            this.showPathsInPanel(paths);
        }
    }

    public Graph getGraph() {
        return this.graph;
    }

    class PathPrinter {
        GraphPath gp;

        PathPrinter(GraphPath gp) {
            this.gp = gp;
        }

        public String toString() {
            SimpleDateFormat shortDateFormat = new SimpleDateFormat("HH:mm:ss z");
            String startTime = shortDateFormat.format(new Date(this.gp.getStartTime() * 1000L));
            String endTime = shortDateFormat.format(new Date(this.gp.getEndTime() * 1000L));
            return "Path (" + startTime + "-" + endTime + ") weight:" + this.gp.getWeight() + " dur:" + (double)this.gp.getDuration() / 60.0 + " walk:" + this.gp.getWalkDistance();
        }
    }

    private final class OnPopupMenuClickListener
    implements ActionListener {
        private OnPopupMenuClickListener() {
        }

        private int[] diffPaths() {
            Vertex v2;
            Vertex v1;
            int i;
            int l2;
            if (GraphVisualizer.this.firstComparePath == null || GraphVisualizer.this.secondComparePath == null) {
                int[] failboat = new int[]{-2, -2};
                return failboat;
            }
            int l1 = GraphVisualizer.this.firstComparePath.states.size();
            int minlen = l1 < (l2 = GraphVisualizer.this.secondComparePath.states.size()) ? l1 : l2;
            int divergence = -1;
            int convergence = -1;
            for (i = 0; i < minlen; ++i) {
                v1 = GraphVisualizer.this.firstComparePath.states.get(i).getVertex();
                if (v1.equals(v2 = GraphVisualizer.this.secondComparePath.states.get(i).getVertex())) continue;
                divergence = i - 1;
                break;
            }
            for (i = 0; i < minlen; ++i) {
                v1 = GraphVisualizer.this.firstComparePath.states.get(l1 - i - 1).getVertex();
                if (v1.equals(v2 = GraphVisualizer.this.secondComparePath.states.get(l2 - i - 1).getVertex())) continue;
                convergence = i - 1;
                break;
            }
            int[] ret = new int[]{divergence, convergence};
            return ret;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DefaultListModel<State> pathModel;
            PathPrinter pp = GraphVisualizer.this.pathsList.getSelectedValue();
            if (pp == null) {
                return;
            }
            GraphPath path = pp.gp;
            GraphVisualizer.this.firstComparePath = GraphVisualizer.this.secondComparePath;
            GraphVisualizer.this.secondComparePath = path;
            if (GraphVisualizer.this.firstComparePath != null) {
                pathModel = new DefaultListModel<State>();
                for (State st : GraphVisualizer.this.firstComparePath.states) {
                    pathModel.addElement(st);
                }
                GraphVisualizer.this.firstComparePathStates.setModel(pathModel);
            }
            if (GraphVisualizer.this.secondComparePath != null) {
                pathModel = new DefaultListModel();
                for (State st : GraphVisualizer.this.secondComparePath.states) {
                    pathModel.addElement(st);
                }
                GraphVisualizer.this.secondComparePathStates.setModel(pathModel);
            }
            int[] diff = this.diffPaths();
            int diverge = diff[0];
            int converge = diff[1];
            if (diff[0] >= 0) {
                GraphVisualizer.this.firstComparePathStates.setCellRenderer(new DiffListCellRenderer(diverge, GraphVisualizer.this.firstComparePath.states.size() - converge - 1));
                GraphVisualizer.this.secondComparePathStates.setCellRenderer(new DiffListCellRenderer(diverge, GraphVisualizer.this.secondComparePath.states.size() - converge - 1));
            }
        }

        private final class DiffListCellRenderer
        extends DefaultListCellRenderer {
            private final int diverge;
            private final int converge;

            private DiffListCellRenderer(int diverge, int converge) {
                this.diverge = diverge;
                this.converge = converge;
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (isSelected) {
                    return c;
                }
                if (index <= this.diverge) {
                    c.setBackground(new Color(196, 201, 255));
                }
                if (index >= this.converge) {
                    c.setBackground(new Color(255, 196, 196));
                }
                return c;
            }
        }
    }

    private final class ComparePathStatesClickListener
    implements ListSelectionListener {
        private JList<String> outputList;

        ComparePathStatesClickListener(JList<String> outputList) {
            this.outputList = outputList;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JList theList = (JList)e.getSource();
            State st = (State)theList.getSelectedValue();
            if (st == null) {
                return;
            }
            DefaultListModel<CallSite> stateListModel = new DefaultListModel<CallSite>();
            stateListModel.addElement((CallSite)((Object)("weight:" + st.getWeight())));
            stateListModel.addElement((CallSite)((Object)("weightdelta:" + st.getWeightDelta())));
            stateListModel.addElement((CallSite)((Object)("rentingVehicle:" + st.isRentingVehicle())));
            stateListModel.addElement((CallSite)((Object)("vehicleParked:" + st.isVehicleParked())));
            stateListModel.addElement((CallSite)((Object)("walkDistance:" + st.getWalkDistance())));
            stateListModel.addElement((CallSite)((Object)("elapsedTime:" + st.getElapsedTimeSeconds())));
            this.outputList.setModel(stateListModel);
            GraphVisualizer.this.lastStateClicked = st;
        }
    }
}

