/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util.xml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Function;
import org.opentripplanner.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonDataListDownloader<T> {
    private static final Logger log = LoggerFactory.getLogger(JsonDataListDownloader.class);
    private String url;
    private final String jsonParsePath;
    private final Map<String, String> headers;
    private final Function<JsonNode, T> elementParser;

    public JsonDataListDownloader(String url, String jsonParsePath, Function<JsonNode, T> elementParser, Map<String, String> headers) {
        this.url = url;
        this.jsonParsePath = jsonParsePath;
        this.headers = headers;
        this.elementParser = elementParser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<T> download() {
        if (this.url == null) {
            log.warn("Cannot download updates, because url is null!");
            return null;
        }
        try (InputStream data = this.openInputStream();){
            if (data == null) {
                log.warn("Failed to get data from url " + this.url);
                List<T> list2 = null;
                return list2;
            }
            List<T> list = this.parseJSON(data);
            return list;
        }
        catch (IllegalArgumentException e) {
            log.warn("Error parsing bike rental feed from " + this.url, (Throwable)e);
            return null;
        }
        catch (JsonProcessingException e) {
            log.warn("Error parsing bike rental feed from " + this.url + "(bad JSON of some sort)", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.warn("Error reading bike rental feed from " + this.url, (Throwable)e);
        }
        return null;
    }

    private InputStream openInputStream() throws IOException {
        URL downloadUrl = new URL(this.url);
        String proto = downloadUrl.getProtocol();
        if (proto.equals("http") || proto.equals("https")) {
            return HttpUtils.getData(URI.create(this.url), this.headers);
        }
        return downloadUrl.openStream();
    }

    private List<T> parseJSON(InputStream dataStream) throws IllegalArgumentException, IOException {
        ArrayList<T> out = new ArrayList<T>();
        String rentalString = JsonDataListDownloader.convertStreamToString(dataStream);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = mapper.readTree(rentalString);
        if (!this.jsonParsePath.equals("")) {
            String[] parseElement;
            String delimiter = "/";
            for (String s : parseElement = this.jsonParsePath.split(delimiter)) {
                rootNode = rootNode.path(s);
            }
            if (rootNode.isMissingNode()) {
                throw new IllegalArgumentException("Could not find jSON elements " + this.jsonParsePath);
            }
        }
        for (JsonNode node : rootNode) {
            T parsedElement;
            if (node == null || (parsedElement = this.elementParser.apply(node)) == null) continue;
            out.add(parsedElement);
        }
        return out;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    private static String convertStreamToString(InputStream is) {
        try (Scanner scanner = new Scanner(is).useDelimiter("\\A");){
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
    }
}

