/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util.time;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.opentripplanner.util.time.DateConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils
implements DateConstants {
    private static final Logger LOG = LoggerFactory.getLogger(DateUtils.class);
    private static final int SANITY_CHECK_CUTOFF_YEAR = 1000;

    public static Date toDate(String date, String time, TimeZone tz) {
        int[] hms;
        LOG.debug("Parsing date {} and time {}", (Object)date, (Object)time);
        LOG.debug("using timezone {}", (Object)tz);
        Date retVal = new Date();
        if (date != null) {
            int[] hms2;
            Date d = DateUtils.parseDate(date, tz);
            if (d == null) {
                return null;
            }
            GregorianCalendar cal = new GregorianCalendar(tz);
            cal.setTime(d);
            boolean timed = false;
            if (time != null && (hms2 = DateUtils.parseTime(time)) != null) {
                cal.set(11, hms2[0]);
                cal.set(12, hms2[1]);
                cal.set(13, hms2[2]);
                cal.set(14, 0);
                timed = true;
            }
            if (!timed) {
                GregorianCalendar today = new GregorianCalendar();
                cal.set(11, today.get(11));
                cal.set(12, today.get(12));
                cal.set(13, today.get(13));
                cal.set(14, today.get(14));
            }
            retVal = cal.getTime();
        } else if (time != null && (hms = DateUtils.parseTime(time)) != null) {
            GregorianCalendar cal = new GregorianCalendar(tz);
            cal.set(11, hms[0]);
            cal.set(12, hms[1]);
            cal.set(13, hms[2]);
            cal.set(14, 0);
            retVal = cal.getTime();
        }
        LOG.debug("resulting date is {}", (Object)retVal);
        return retVal;
    }

    private static int[] parseTime(String time) {
        int[] retVal = null;
        boolean amPm = false;
        int addHours = 0;
        int hour = 0;
        int min = 0;
        int sec = 0;
        try {
            String[] hms = time.toUpperCase().split(":");
            if (hms.length < 2) {
                int secondsPastMidnight = DateUtils.getIntegerFromString(time);
                retVal = new int[]{secondsPastMidnight / 3600, secondsPastMidnight % 3600 / 60, secondsPastMidnight % 60};
            }
            if (hms[1].endsWith("PM") || hms[1].endsWith("AM")) {
                int suffex;
                amPm = true;
                if (hms[1].contains("PM")) {
                    addHours = 12;
                }
                if ((suffex = hms[1].lastIndexOf(32)) < 1 && (suffex = hms[1].lastIndexOf("AM")) < 1) {
                    suffex = hms[1].lastIndexOf("PM");
                }
                hms[1] = hms[1].substring(0, suffex);
            }
            int h = Integer.parseInt(DateUtils.trim(hms[0]));
            if (amPm && h == 12) {
                h = 0;
            }
            hour = h + addHours;
            min = Integer.parseInt(DateUtils.trim(hms[1]));
            if (hms.length > 2) {
                sec = Integer.parseInt(DateUtils.trim(hms[2]));
            }
            retVal = new int[]{hour, min, sec};
        }
        catch (Exception ignore) {
            LOG.info("Time '{}' didn't parse", (Object)time);
            retVal = null;
        }
        return retVal;
    }

    public static Date parseDate(String input, TimeZone tz) {
        Date retVal;
        block7: {
            retVal = null;
            try {
                Object newString = input.trim().replace('_', '.').replace('-', '.').replace(':', '.').replace('/', '.');
                if (newString == null) break block7;
                List dl = DF_LIST;
                if (((String)newString).length() <= 8) {
                    if (((String)newString).matches("\\d\\d\\d\\d\\d\\d\\d\\d")) {
                        newString = ((String)newString).substring(0, 4) + "." + ((String)newString).substring(4, 6) + "." + ((String)newString).substring(6, 8);
                    } else if (!((String)newString).matches(".*20\\d\\d.*")) {
                        dl = SMALL_DF_LIST;
                    }
                }
                for (String df : dl) {
                    SimpleDateFormat sdf = new SimpleDateFormat(df);
                    sdf.setTimeZone(tz);
                    retVal = DateUtils.parseDate(sdf, (String)newString);
                    if (retVal == null) continue;
                    GregorianCalendar cal = new GregorianCalendar(tz);
                    cal.setTime(retVal);
                    int year = cal.get(1);
                    if (year < 1000) continue;
                    break;
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not parse " + input);
            }
        }
        return retVal;
    }

    public static int getIntegerFromString(String input) {
        try {
            return new Integer(input);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static String secToHHMM(int seconds) {
        int min;
        String sign = "";
        if (seconds >= 0) {
            min = seconds / 60;
            sign = "";
        } else {
            min = -seconds / 60;
            sign = "-";
        }
        int mm = min % 60;
        int hh = min / 60;
        return String.format("%s%d:%02d", sign, hh, mm);
    }

    public static String trim(String str) {
        String retVal = str;
        try {
            retVal = str.trim();
            retVal = retVal.replaceAll("%20;", "");
            retVal = retVal.replaceAll("%20", "");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public static String formatDate(String sdfFormat, Date date, TimeZone tz) {
        return DateUtils.formatDate(sdfFormat, date, null, tz);
    }

    public static String formatDate(String sdfFormat, Date date, String defValue, TimeZone tz) {
        String retVal = defValue;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(sdfFormat);
            sdf.setTimeZone(tz);
            retVal = sdf.format(date);
        }
        catch (Exception e) {
            retVal = defValue;
        }
        return retVal;
    }

    public static Date parseDate(String sdf, String string) {
        return DateUtils.parseDate(new SimpleDateFormat(sdf), string);
    }

    public static synchronized Date parseDate(SimpleDateFormat sdf, String string) {
        sdf.setLenient(false);
        try {
            return sdf.parse(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static long absoluteTimeout(double relativeTimeoutSeconds) {
        if (relativeTimeoutSeconds <= 0.0) {
            return Long.MAX_VALUE;
        }
        return System.currentTimeMillis() + (long)(relativeTimeoutSeconds * 1000.0);
    }
}

