/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util.stats;

import com.google.common.collect.Multiset;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import java.text.MessageFormat;
import java.util.Locale;
import org.opentripplanner.util.stats.Quantifiable;

public class DiscreteDistribution<K extends Quantifiable<?>> {
    private double totK = 0.0;
    private SortedMultiset<K> distribution = TreeMultiset.create();

    public void add(K k) {
        this.totK += k.doubleValue();
        this.distribution.add(k, 1);
    }

    public void add(K k, String sample) {
        this.totK += k.doubleValue();
        if (this.distribution.count(k) == 0) {
            System.out.println(k.doubleValue() + " => " + sample);
        }
        this.distribution.add(k, 1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int totCount = this.distribution.size();
        int minCount = Integer.MAX_VALUE;
        int maxCount = 0;
        for (Multiset.Entry e : this.distribution.entrySet()) {
            int count = e.getCount();
            if (count < minCount) {
                minCount = count;
            }
            if (count <= maxCount) continue;
            maxCount = count;
        }
        sb.append(String.format("K: Total: %.02f, avg: %.02f, min: %s, max: %s\n", this.totK, this.totK * 1.0 / (double)totCount, this.distribution.firstEntry().getElement(), this.distribution.lastEntry().getElement()));
        sb.append(String.format("C: Total: %d, min: %d, max: %d\n", totCount, minCount, maxCount));
        for (Multiset.Entry e : this.distribution.entrySet()) {
            sb.append(MessageFormat.format("{0} : {1} {2}\n", ((Quantifiable)e.getElement()).toString(), this.chart(e.getCount(), maxCount, 60), e.getCount()));
        }
        sb.append("----------------------------------------------------------------");
        return sb.toString();
    }

    private String chart(int x, int xMax, int len) {
        StringBuffer retval = new StringBuffer();
        int i = 0;
        while ((long)i < Math.round((double)x * 1.0 * (double)len / (double)xMax)) {
            retval.append("*");
            ++i;
        }
        return retval.toString();
    }

    public static class ConstantQuantifiable<K extends Comparable<K>>
    implements Quantifiable<ConstantQuantifiable<K>> {
        private K k;

        public ConstantQuantifiable(K k) {
            this.k = k;
        }

        public int hashCode() {
            return this.k.hashCode();
        }

        public boolean equals(Object another) {
            if (another instanceof ConstantQuantifiable) {
                ConstantQuantifiable other = (ConstantQuantifiable)another;
                return other.k.equals(this.k);
            }
            return false;
        }

        @Override
        public int compareTo(ConstantQuantifiable<K> o) {
            return this.k.compareTo(o.k);
        }

        @Override
        public double doubleValue() {
            return 1.0;
        }

        public String toString() {
            return this.k.toString();
        }
    }

    public static class LogQuantifiable<K extends Number>
    implements Quantifiable<LogQuantifiable<K>> {
        private int log;
        private double mult;
        private K k;

        public LogQuantifiable(K k, double mult) {
            this.mult = mult;
            this.k = k;
            this.log = (int)Math.round(Math.log(((Number)k).doubleValue()) * mult);
        }

        public int hashCode() {
            return this.log;
        }

        public boolean equals(Object another) {
            if (another instanceof LogQuantifiable) {
                LogQuantifiable anotherLog = (LogQuantifiable)another;
                return anotherLog.log == this.log;
            }
            return false;
        }

        @Override
        public int compareTo(LogQuantifiable<K> o) {
            return Integer.compare(this.log, o.log);
        }

        @Override
        public double doubleValue() {
            return ((Number)this.k).doubleValue();
        }

        public String toString() {
            double min = Math.exp((double)this.log / this.mult);
            double max = Math.exp((double)(this.log + 1) / this.mult);
            return String.format(Locale.ROOT, "%.2f-%.2f", min, max);
        }
    }

    public static class NumberQuantifiable<K extends Number>
    implements Quantifiable<NumberQuantifiable<K>> {
        private K num;

        public NumberQuantifiable(K num) {
            this.num = num;
        }

        public int hashCode() {
            return this.num.hashCode();
        }

        public boolean equals(Object another) {
            if (another instanceof NumberQuantifiable) {
                NumberQuantifiable other = (NumberQuantifiable)another;
                return other.num.equals(this.num);
            }
            return false;
        }

        @Override
        public int compareTo(NumberQuantifiable<K> o) {
            return Double.compare(((Number)this.num).doubleValue(), ((Number)o.num).doubleValue());
        }

        @Override
        public double doubleValue() {
            return ((Number)this.num).doubleValue();
        }

        public String toString() {
            return this.num.toString();
        }
    }
}

