/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util.logging;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.GuavaCacheMetrics;
import io.micrometer.core.instrument.binder.jvm.ClassLoaderMetrics;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmCompilationMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmHeapPressureMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmInfoMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import io.micrometer.core.instrument.binder.system.FileDescriptorMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.standalone.server.OTPServer;
import org.opentripplanner.standalone.server.Router;

public class MetricsLogging {
    public MetricsLogging(OTPServer otpServer) {
        new ClassLoaderMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new FileDescriptorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmCompilationMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmGcMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmHeapPressureMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmInfoMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmMemoryMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new JvmThreadMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new LogbackMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new ProcessorMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        new UptimeMetrics().bindTo((MeterRegistry)Metrics.globalRegistry);
        Router router = otpServer.getRouter();
        Graph graph = router.graph;
        if (graph.getTransitLayer() != null) {
            new GuavaCacheMetrics(graph.getTransitLayer().getTransferCache().getTransferCache(), "raptorTransfersCache", List.of(Tag.of((String)"cache", (String)"raptorTransfers"))).bindTo((MeterRegistry)Metrics.globalRegistry);
        }
        new ExecutorServiceMetrics((ExecutorService)ForkJoinPool.commonPool(), "commonPool", List.of(Tag.of((String)"pool", (String)"commonPool"))).bindTo((MeterRegistry)Metrics.globalRegistry);
        if (graph.updaterManager != null) {
            new ExecutorServiceMetrics(graph.updaterManager.getUpdaterPool(), "graphUpdaters", List.of(Tag.of((String)"pool", (String)"graphUpdaters"))).bindTo((MeterRegistry)Metrics.globalRegistry);
            new ExecutorServiceMetrics((ExecutorService)graph.updaterManager.getScheduler(), "graphUpdateScheduler", List.of(Tag.of((String)"pool", (String)"graphUpdateScheduler"))).bindTo((MeterRegistry)Metrics.globalRegistry);
        }
        if (router.raptorConfig.isMultiThreaded()) {
            new ExecutorServiceMetrics(router.raptorConfig.threadPool(), "raptorHeuristics", List.of(Tag.of((String)"pool", (String)"raptorHeuristics"))).bindTo((MeterRegistry)Metrics.globalRegistry);
        }
    }
}

