/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util.logging;

import org.opentripplanner.util.logging.AbstractFilterLogger;
import org.slf4j.Logger;

public class MaxCountLogger
extends AbstractFilterLogger {
    private static final int MAX_COUNT = 10;
    private int count = 0;

    public MaxCountLogger(Logger delegate) {
        super(delegate);
    }

    public static MaxCountLogger maxCount(Logger log) {
        return new MaxCountLogger(log);
    }

    @Override
    boolean mute() {
        ++this.count;
        return this.count > 10;
    }

    public void logTotal(String message) {
        if (this.mute()) {
            this.getDelegate().warn("TOTAL: {} - {}", (Object)this.count, (Object)message);
        }
    }
}

