/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opentripplanner.model.TransitMode;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.util.TravelOption;

public final class TravelOptionsMaker {
    private static List<TravelOption> staticTravelOptions = new ArrayList<TravelOption>(3);

    public static List<TravelOption> makeOptions(Graph graph) {
        return TravelOptionsMaker.makeOptions(graph.getTransitModes(), graph.hasBikeSharing, graph.hasBikeRide, graph.hasParkRide);
    }

    public static List<TravelOption> makeOptions(HashSet<TransitMode> transitModes, boolean hasBikeSharing, boolean hasBikeRide, boolean hasParkRide) {
        ArrayList<TravelOption> travelOptions = new ArrayList<TravelOption>(16);
        if (!transitModes.isEmpty()) {
            travelOptions.add(new TravelOption(String.join((CharSequence)",", TraverseMode.TRANSIT.toString(), TraverseMode.WALK.toString()), TraverseMode.TRANSIT.toString()));
            for (TransitMode transitMode : transitModes) {
                travelOptions.add(new TravelOption(String.join((CharSequence)",", transitMode.toString(), TraverseMode.WALK.toString()), transitMode.toString()));
            }
        }
        travelOptions.addAll(staticTravelOptions);
        if (hasBikeSharing) {
            travelOptions.add(new TravelOption(String.join((CharSequence)",", TraverseMode.WALK.toString(), "BICYCLE_RENT"), "BICYCLERENT"));
        }
        if (!transitModes.isEmpty()) {
            travelOptions.add(new TravelOption(String.join((CharSequence)",", TraverseMode.TRANSIT.toString(), TraverseMode.BICYCLE.toString()), String.join((CharSequence)"_", TraverseMode.TRANSIT.toString(), TraverseMode.BICYCLE.toString())));
            if (hasBikeSharing) {
                travelOptions.add(new TravelOption(String.join((CharSequence)",", TraverseMode.TRANSIT.toString(), TraverseMode.WALK.toString(), "BICYCLE_RENT"), "TRANSIT_BICYCLERENT"));
            }
            if (hasParkRide) {
                travelOptions.add(new TravelOption(String.join((CharSequence)",", "CAR_PARK", TraverseMode.WALK.toString(), TraverseMode.TRANSIT.toString()), "PARKRIDE"));
            }
            if (hasBikeRide) {
                travelOptions.add(new TravelOption(String.join((CharSequence)",", "BICYCLE_PARK", TraverseMode.WALK.toString(), TraverseMode.TRANSIT.toString()), "BIKERIDE"));
            }
            travelOptions.add(new TravelOption(String.join((CharSequence)",", TraverseMode.CAR.toString(), TraverseMode.WALK.toString(), TraverseMode.TRANSIT.toString()), "KISSRIDE"));
        }
        return travelOptions;
    }

    static {
        staticTravelOptions.add(new TravelOption(TraverseMode.WALK.toString()));
        staticTravelOptions.add(new TravelOption(TraverseMode.BICYCLE.toString()));
        staticTravelOptions.add(new TravelOption(TraverseMode.CAR.toString()));
    }
}

