/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.NonLocalizedString;

public class TranslatedString
implements I18NString,
Serializable {
    private static final HashMap<Map<String, String>, I18NString> intern = new HashMap();
    private final Map<String, String> translations = new HashMap<String, String>();

    private TranslatedString(Map<String, String> translations) {
        for (Map.Entry<String, String> i : translations.entrySet()) {
            if (i.getKey() == null) {
                this.translations.put(null, i.getValue());
                continue;
            }
            this.translations.put(i.getKey().toLowerCase(), i.getValue());
        }
    }

    public boolean equals(Object other) {
        return other instanceof TranslatedString && this.translations.equals(((TranslatedString)other).translations);
    }

    public int hashCode() {
        return Objects.hash(this.translations);
    }

    public static I18NString getI18NString(Map<String, String> translations) {
        if (intern.containsKey(translations)) {
            return intern.get(translations);
        }
        I18NString ret = new HashSet<String>(translations.values()).size() < 2 ? new NonLocalizedString(translations.values().iterator().next()) : new TranslatedString(translations);
        intern.put(translations, ret);
        return ret;
    }

    public Collection<String> getLanguages() {
        return this.translations.keySet();
    }

    public List<Map.Entry<String, String>> getTranslations() {
        return new ArrayList<Map.Entry<String, String>>(this.translations.entrySet());
    }

    @Override
    public String toString() {
        return this.translations.containsKey(null) ? this.translations.get(null) : this.translations.values().iterator().next();
    }

    @Override
    public String toString(Locale locale) {
        String language = null;
        if (locale != null) {
            language = locale.getLanguage().toLowerCase();
        }
        return this.translations.containsKey(language) ? this.translations.get(language) : this.toString();
    }
}

