/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TableFormatter {
    private final List<Align> aligns = new ArrayList<Align>();
    private final List<String> headers = new ArrayList<String>();
    private final List<Integer> widths = new ArrayList<Integer>();
    private final List<List<String>> rows = new ArrayList<List<String>>();

    public TableFormatter(Collection<Align> aligns, Collection<String> headers) {
        if (aligns.size() != headers.size()) {
            throw new IllegalArgumentException();
        }
        this.aligns.addAll(aligns);
        this.headers.addAll(headers);
        this.headers.forEach(it -> this.widths.add(it.length()));
    }

    public TableFormatter(Collection<Align> aligns, Collection<String> headers, int ... widths) {
        if (aligns.size() != headers.size() || aligns.size() != widths.length) {
            throw new IllegalArgumentException();
        }
        this.aligns.addAll(aligns);
        this.headers.addAll(headers);
        for (int i = 0; i < widths.length; ++i) {
            int width = Math.max(this.headers.get(i).length(), widths[i]);
            this.widths.add(width);
        }
    }

    public String printHeader() {
        StringBuilder buf = new StringBuilder();
        this.appendRow(buf, this.headers, this::padHeader);
        return buf.toString();
    }

    public String printRow(Object ... row) {
        StringBuilder buf = new StringBuilder();
        this.appendRow(buf, TableFormatter.toStrings(row), this::pad);
        return buf.toString();
    }

    public void addRow(Object ... row) {
        this.addRow(Arrays.stream(row).collect(Collectors.toList()));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.appendRowLn(buf, this.headers, this::padHeader);
        for (List<String> row : this.rows) {
            this.appendRowLn(buf, row, this::pad);
        }
        return buf.toString();
    }

    private void addRow(Collection<?> row) {
        this.assertRowIsLessThanOrSameSizeAsHeader(row);
        List<String> aRow = TableFormatter.toStrings(row);
        this.setColumnWidths(aRow);
        this.rows.add(aRow);
    }

    private void appendRow(StringBuilder buf, List<String> row, BiFunction<List<String>, Integer, String> pad) {
        for (int i = 0; i < row.size(); ++i) {
            if (i != 0) {
                buf.append(" | ");
            }
            buf.append(pad.apply(row, i));
        }
    }

    private void appendRowLn(StringBuilder buf, List<String> row, BiFunction<List<String>, Integer, String> pad) {
        this.appendRow(buf, row, pad);
        buf.append('\n');
    }

    private String pad(List<String> row, int i) {
        return this.aligns.get(i).pad(row.get(i), this.widths.get(i));
    }

    private String padHeader(List<String> row, int i) {
        return this.headerAlignment(i).pad(row.get(i), this.widths.get(i));
    }

    private Align headerAlignment(int i) {
        return this.aligns.get(i) == Align.Left ? Align.Left : Align.Center;
    }

    private void setColumnWidths(List<String> row) {
        for (int i = 0; i < row.size(); ++i) {
            this.widths.set(i, Math.max(this.widths.get(i), row.get(i).length()));
        }
    }

    private static List<String> toStrings(Collection<?> row) {
        return row.stream().map(it -> it == null ? "" : it.toString()).collect(Collectors.toList());
    }

    private static List<String> toStrings(Object ... row) {
        return Arrays.stream(row).map(it -> it == null ? "" : it.toString()).collect(Collectors.toList());
    }

    private void assertRowIsLessThanOrSameSizeAsHeader(Collection<?> row) {
        if (row.size() > this.headers.size()) {
            throw new IllegalArgumentException("Can not add row with more columns than the header. Row size: " + row.size() + ", Header size: " + this.headers.size());
        }
    }

    private static String padLeft(String value, int width) {
        return TableFormatter.pad(value, width, b -> false);
    }

    private static String padRight(String value, int width) {
        return TableFormatter.pad(value, width, b -> true);
    }

    private static String padCenter(String value, int width) {
        return TableFormatter.pad(value, width, b -> b == false);
    }

    private static String pad(String value, int width, Function<Boolean, Boolean> toRight) {
        boolean toggle = toRight.apply(false);
        StringBuilder buf = new StringBuilder(value);
        while (buf.length() < width) {
            if (toggle) {
                buf.insert(0, ' ');
            } else {
                buf.append(' ');
            }
            toggle = toRight.apply(toggle);
        }
        value = buf.toString();
        return value;
    }

    public static enum Align {
        Left((x$0, x$1) -> TableFormatter.padLeft(x$0, x$1)),
        Center((x$0, x$1) -> TableFormatter.padCenter(x$0, x$1)),
        Right((x$0, x$1) -> TableFormatter.padRight(x$0, x$1));

        private final BiFunction<String, Integer, String> padFunction;

        private Align(BiFunction<String, Integer, String> padFunction) {
            this.padFunction = padFunction;
        }

        String pad(String value, int width) {
            return this.padFunction.apply(value, width);
        }
    }
}

