/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ResourceBundleSingleton {
    INSTANCE;

    private static final Logger LOG;
    static final ResourceBundle.Control noFallbackControl;
    private static final Locale defaultLocale;

    public String localize(String key, Locale locale) {
        if (key == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.ROOT;
        }
        try {
            ResourceBundle resourceBundle = null;
            resourceBundle = key.equals("corner") || key.equals("unnamedStreet") || key.equals("origin") || key.equals("destination") ? ResourceBundle.getBundle("internals", locale, noFallbackControl) : ResourceBundle.getBundle("WayProperties", locale, noFallbackControl);
            String retval = resourceBundle.getString(key);
            return retval;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public Locale getLocale(String localeSpec) {
        if (localeSpec == null || localeSpec.isEmpty()) {
            return defaultLocale;
        }
        String[] localeSpecParts = localeSpec.split("_");
        switch (localeSpecParts.length) {
            case 1: {
                return new Locale(localeSpecParts[0]);
            }
            case 2: {
                return new Locale(localeSpecParts[0]);
            }
            case 3: {
                return new Locale(localeSpecParts[0]);
            }
        }
        LOG.debug("Bogus locale " + localeSpec + ", using default");
        return defaultLocale;
    }

    static {
        LOG = LoggerFactory.getLogger(ResourceBundleSingleton.class);
        noFallbackControl = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES);
        defaultLocale = Locale.ENGLISH;
    }
}

