/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.opentripplanner.util.IntUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Properties {
    public static final Logger LOG = LoggerFactory.getLogger(Properties.class);
    private final String bundle;

    public Properties() {
        this(Properties.class);
    }

    public Properties(Class<?> c) {
        this.bundle = c.getSimpleName();
    }

    public Properties(String bundle) {
        this.bundle = bundle;
    }

    public static ResourceBundle getBundle(String name, Locale l) {
        try {
            return ResourceBundle.getBundle(name, l);
        }
        catch (Exception e) {
            LOG.error("Uh oh...no .properties file could be found, so things are most definately not going to turn out well!!!", (Throwable)e);
            return null;
        }
    }

    public synchronized String get(String name, Locale l) throws Exception {
        ResourceBundle rb = Properties.getBundle(this.bundle, l);
        return rb.getString(name);
    }

    public synchronized String get(String name) throws Exception {
        ResourceBundle rb = Properties.getBundle(this.bundle, Locale.getDefault());
        return rb.getString(name);
    }

    public String get(String name, String def, Locale l) {
        String retVal = null;
        try {
            retVal = this.get(name, l);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (retVal == null || retVal.length() < 1) {
            retVal = def;
        }
        return retVal;
    }

    public String get(String name, String def) {
        return this.get(name, def, Locale.getDefault());
    }

    public boolean get(String name, boolean def, Locale l) {
        boolean retVal = def;
        try {
            String s = this.get(name, l);
            if (s.toLowerCase().equals("true")) {
                retVal = true;
            }
        }
        catch (Exception e) {
            retVal = def;
        }
        return retVal;
    }

    public boolean get(String name, boolean def) {
        return this.get(name, def, Locale.getDefault());
    }

    public int get(String name, int def, Locale l) {
        String tmp = this.get(name, Integer.toString(def), l);
        return IntUtils.getIntFromString(tmp);
    }

    public int get(String name, int def) {
        return this.get(name, def, Locale.getDefault());
    }

    public long get(String name, long def, Locale l) {
        String tmp = this.get(name, Long.toString(def), l);
        return IntUtils.getLongFromString(tmp);
    }

    public long get(String name, long def) {
        return this.get(name, def, Locale.getDefault());
    }

    public boolean is(String name, Locale l) {
        boolean retVal = false;
        try {
            String r = this.get(name, l);
            if (r != null && r.equalsIgnoreCase("true")) {
                retVal = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retVal;
    }

    public boolean is(String name) {
        return this.is(name, Locale.getDefault());
    }

    public synchronized String format(String name, Locale l, Object ... args) {
        try {
            ResourceBundle rb = Properties.getBundle(this.bundle, l);
            return MessageFormat.format(rb.getString(name), args);
        }
        catch (Exception e) {
            LOG.warn("couldn't find / format property " + name + "; returning null", (Throwable)e);
            return null;
        }
    }

    public synchronized String format(String name, Object ... args) {
        return this.format(name, Locale.getDefault(), args);
    }
}

