/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Consumer;
import org.opentripplanner.util.ProgressTracker;

class ProgressTrackerOutputStream
extends OutputStream {
    private final ProgressTracker progress;
    private final Consumer<String> logger;
    private final OutputStream delegate;

    public ProgressTrackerOutputStream(ProgressTracker progress, OutputStream delegate, Consumer<String> logger) {
        this.progress = progress;
        this.delegate = delegate;
        this.logger = logger;
        this.logger.accept(this.progress.startMessage());
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.progress.steps(b.length, this.logger);
        this.delegate.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.progress.steps(len - off, this.logger);
        this.delegate.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.progress.step(this.logger);
        this.delegate.write(b);
    }

    @Override
    public void close() throws IOException {
        this.logger.accept(this.progress.completeMessage());
        this.delegate.close();
    }
}

