/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.opentripplanner.common.LoggingUtil;
import org.opentripplanner.util.ProgressTrackerInputStream;
import org.opentripplanner.util.ProgressTrackerOutputStream;
import org.opentripplanner.util.time.DurationUtils;

public class ProgressTracker {
    public static final int QUIET_PERIOD_MILLISECONDS = 5000;
    private final long expectedNumberOfSteps;
    private final long quietPeriodMilliseconds;
    private final boolean logFormatAsBytes;
    private final int minBlockSize;
    private final String actionName;
    private final AtomicLong stepCounter = new AtomicLong(0L);
    private final Instant startTime;
    private Instant lastNotification;

    public static ProgressTracker track(String actionName, int minBlockSize, long size) {
        return new ProgressTracker(actionName, minBlockSize, size, 5000L, false);
    }

    public static InputStream track(String actionName, int minBlockSize, long size, InputStream inputStream, Consumer<String> progressNotification) {
        return new ProgressTrackerInputStream(new ProgressTracker(actionName, minBlockSize, size, 5000L, true), inputStream, progressNotification);
    }

    public static OutputStream track(String actionName, int minBlockSize, long size, OutputStream outputStream, Consumer<String> progressNotification) {
        return new ProgressTrackerOutputStream(new ProgressTracker(actionName, minBlockSize, size, 5000L, true), outputStream, progressNotification);
    }

    ProgressTracker(String actionName, int minBlockSize, long expectedNumberOfSteps, long quietPeriodMilliseconds, boolean logFormatAsBytes) {
        this.actionName = actionName;
        this.minBlockSize = Math.max(1, minBlockSize);
        this.logFormatAsBytes = logFormatAsBytes;
        this.expectedNumberOfSteps = expectedNumberOfSteps;
        this.quietPeriodMilliseconds = quietPeriodMilliseconds;
        this.lastNotification = this.startTime = Instant.now();
    }

    public String startMessage() {
        return this.actionName + " progress tracking started.";
    }

    public void step(Consumer<String> progressNotification) {
        long counter = this.stepCounter.incrementAndGet();
        if (counter % (long)this.minBlockSize != 0L) {
            return;
        }
        this.notifyIfQuietPeriodIsOver(counter, progressNotification);
    }

    public void steps(int deltaSteps, Consumer<String> progressNotification) {
        long nextNotificationIndex;
        long prev = this.stepCounter.getAndAdd(deltaSteps);
        long counter = prev + (long)deltaSteps;
        if (counter < (nextNotificationIndex = (1L + prev / (long)this.minBlockSize) * (long)this.minBlockSize)) {
            return;
        }
        this.notifyIfQuietPeriodIsOver(counter, progressNotification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyIfQuietPeriodIsOver(long counter, Consumer<String> notification) {
        Instant time = Instant.now();
        ProgressTracker progressTracker = this;
        synchronized (progressTracker) {
            if (time.isBefore(this.lastNotification.plusMillis(this.quietPeriodMilliseconds))) {
                return;
            }
            this.lastNotification = time;
        }
        if (this.expectedNumberOfSteps > 0L) {
            long p = 100L * counter / this.expectedNumberOfSteps;
            notification.accept(String.format("%s progress: %s of %s (%2d%%)", this.actionName, this.toStr(counter), this.toStr(this.expectedNumberOfSteps), p));
        } else {
            notification.accept(String.format("%s progress: %s done", this.actionName, this.toStr(counter)));
        }
    }

    public String completeMessage() {
        long ii = this.stepCounter.get();
        Duration totalTime = Duration.between(this.startTime, Instant.now());
        String stepsPerSecond = this.toStr(Math.round(1000.0 * (double)ii / (double)(totalTime.toMillis() + 1L)));
        return String.format("%s progress tracking complete. %s done in %s (%s per second). ", this.actionName, this.toStr(ii), DurationUtils.durationToStr(totalTime), stepsPerSecond);
    }

    private String toStr(long value) {
        return this.logFormatAsBytes ? LoggingUtil.fileSizeToString(value) : DecimalFormat.getInstance().format(value);
    }
}

