/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opentripplanner.util.model.EncodedPolylineBean;

public class PolylineEncoder {
    public static EncodedPolylineBean createEncodings(double[] lat, double[] lon) {
        return PolylineEncoder.createEncodings(new PointAdapterList(lat, lon));
    }

    public static EncodedPolylineBean createEncodings(double[] lat, double[] lon, int level) {
        return PolylineEncoder.createEncodings(new PointAdapterList(lat, lon), level);
    }

    public static EncodedPolylineBean createEncodings(double[] lat, double[] lon, int offset, int length, int level) {
        return PolylineEncoder.createEncodings(new PointAdapterList(lat, lon, offset, length), level);
    }

    public static EncodedPolylineBean createEncodings(Iterable<Coordinate> points) {
        return PolylineEncoder.createEncodings(points, -1);
    }

    public static EncodedPolylineBean createEncodings(Geometry geometry) {
        if (geometry instanceof LineString) {
            LineString string = (LineString)geometry;
            Coordinate[] coordinates = string.getCoordinates();
            return PolylineEncoder.createEncodings(new CoordinateList(coordinates));
        }
        if (geometry instanceof MultiLineString) {
            MultiLineString mls = (MultiLineString)geometry;
            return PolylineEncoder.createEncodings(new CoordinateList(mls.getCoordinates()));
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            return PolylineEncoder.createEncodings(new CoordinateList(polygon.getCoordinates()));
        }
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            return PolylineEncoder.createEncodings(new CoordinateList(point.getCoordinates()));
        }
        throw new IllegalArgumentException(geometry.toString());
    }

    public static EncodedPolylineBean createEncodings(Iterable<Coordinate> points, int level) {
        StringBuilder encodedPoints = new StringBuilder();
        StringBuilder encodedLevels = new StringBuilder();
        int plat = 0;
        int plng = 0;
        int count = 0;
        for (Coordinate point : points) {
            int late5 = PolylineEncoder.floor1e5(point.y);
            int lnge5 = PolylineEncoder.floor1e5(point.x);
            int dlat = late5 - plat;
            int dlng = lnge5 - plng;
            plat = late5;
            plng = lnge5;
            encodedPoints.append(PolylineEncoder.encodeSignedNumber(dlat)).append(PolylineEncoder.encodeSignedNumber(dlng));
            if (level >= 0) {
                encodedLevels.append(PolylineEncoder.encodeNumber(level));
            }
            ++count;
        }
        String pointsString = encodedPoints.toString();
        String levelsString = level >= 0 ? encodedLevels.toString() : null;
        return new EncodedPolylineBean(pointsString, levelsString, count);
    }

    public static List<Coordinate> decode(EncodedPolylineBean polyline) {
        String pointString = polyline.getPoints();
        double lat = 0.0;
        double lon = 0.0;
        int strIndex = 0;
        ArrayList<Coordinate> points = new ArrayList<Coordinate>();
        while (strIndex < pointString.length()) {
            int[] rLat = PolylineEncoder.decodeSignedNumberWithIndex(pointString, strIndex);
            strIndex = rLat[1];
            int[] rLon = PolylineEncoder.decodeSignedNumberWithIndex(pointString, strIndex);
            strIndex = rLon[1];
            points.add(new Coordinate(lon += (double)rLon[0] * 1.0E-5, lat += (double)rLat[0] * 1.0E-5));
        }
        return points;
    }

    private static final int floor1e5(double coordinate) {
        return (int)Math.floor(coordinate * 100000.0);
    }

    public static String encodeSignedNumber(int num) {
        int sgn_num = num << 1;
        if (num < 0) {
            sgn_num ^= 0xFFFFFFFF;
        }
        return PolylineEncoder.encodeNumber(sgn_num);
    }

    public static int decodeSignedNumber(String value) {
        int[] r = PolylineEncoder.decodeSignedNumberWithIndex(value, 0);
        return r[0];
    }

    public static int[] decodeSignedNumberWithIndex(String value, int index) {
        int[] r = PolylineEncoder.decodeNumberWithIndex(value, index);
        int sgn_num = r[0];
        if ((sgn_num & 1) > 0) {
            sgn_num ^= 0xFFFFFFFF;
        }
        r[0] = sgn_num >> 1;
        return r;
    }

    public static String encodeNumber(int num) {
        StringBuffer encodeString = new StringBuffer();
        while (num >= 32) {
            int nextValue = (0x20 | num & 0x1F) + 63;
            encodeString.append((char)nextValue);
            num >>= 5;
        }
        encodeString.append((char)(num += 63));
        return encodeString.toString();
    }

    public static int decodeNumber(String value) {
        int[] r = PolylineEncoder.decodeNumberWithIndex(value, 0);
        return r[0];
    }

    public static int[] decodeNumberWithIndex(String value, int index) {
        if (value.length() == 0) {
            throw new IllegalArgumentException("string is empty");
        }
        int num = 0;
        int v = 0;
        int shift = 0;
        do {
            v = value.charAt(index++) - 63;
            num |= (v & 0x1F) << shift;
            shift += 5;
        } while (v >= 32);
        return new int[]{num, index};
    }

    private static class CoordinateList
    extends AbstractList<Coordinate> {
        private Coordinate[] coordinates;

        public CoordinateList(Coordinate[] coordinates) {
            this.coordinates = coordinates;
        }

        @Override
        public Coordinate get(int index) {
            return this.coordinates[index];
        }

        @Override
        public int size() {
            return this.coordinates.length;
        }
    }

    private static class PointAdapterList
    extends AbstractList<Coordinate> {
        private double[] lat;
        private double[] lon;
        private int offset;
        private int length;

        public PointAdapterList(double[] lat, double[] lon) {
            this(lat, lon, 0, lat.length);
        }

        public PointAdapterList(double[] lat, double[] lon, int offset, int length) {
            this.lat = lat;
            this.lon = lon;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public Coordinate get(int index) {
            return new Coordinate(this.lon[this.offset + index], this.lat[this.offset + index]);
        }

        @Override
        public int size() {
            return this.length;
        }
    }
}

