/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OTPFeature {
    APIBikeRental(true),
    APIServerInfo(true),
    APIGraphInspectorTile(true),
    APIUpdaterStatus(true),
    MinimumTransferTimeIsDefinitive(false),
    OptimizeTransfers(true),
    ParallelRouting(false),
    TransferConstraints(true),
    ActuatorAPI(false),
    DataOverlay(false),
    FlexRouting(false),
    FloatingBike(false),
    GoogleCloudStorage(false),
    ReportApi(false),
    SandboxAPILegacyGraphQLApi(false),
    SandboxAPIMapboxVectorTilesApi(false),
    SandboxAPITransmodelApi(false),
    SandboxExampleAPIGraphStatistics(false),
    SandboxAPIParkAndRideApi(false),
    TransferAnalyzer(false);

    private static final Logger LOG;
    private boolean enabled;

    private OTPFeature(boolean defaultEnabled) {
        this.enabled = defaultEnabled;
    }

    public static void enableFeatures(Map<OTPFeature, Boolean> map) {
        map.forEach(OTPFeature::set);
    }

    public boolean isOn() {
        return this.enabled;
    }

    public boolean isOff() {
        return !this.enabled;
    }

    void set(boolean enabled) {
        this.enabled = enabled;
    }

    public <T> T isOnElseNull(Supplier<T> supplier) {
        return this.isOn() ? (T)supplier.get() : null;
    }

    public static void logFeatureSetup() {
        LOG.info("Features turned on: \n\t" + OTPFeature.valuesAsString(true));
        LOG.info("Features turned off: \n\t" + OTPFeature.valuesAsString(false));
    }

    private static String valuesAsString(boolean enabled) {
        return Arrays.stream(OTPFeature.values()).filter(it -> it.enabled == enabled).map(Enum::name).collect(Collectors.joining("\n\t"));
    }

    static {
        LOG = LoggerFactory.getLogger(OTPFeature.class);
    }
}

