/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import gnu.trove.map.TLongObjectMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MapUtils {
    public static final <U> void addToMapSet(TLongObjectMap<Set<U>> mapSet, long key, U value) {
        HashSet<U> set = (HashSet<U>)mapSet.get(key);
        if (set == null) {
            set = new HashSet<U>();
            mapSet.put(key, set);
        }
        set.add(value);
    }

    public static final <T, U> void addToMapList(Map<T, List<U>> mapList, T key, U value) {
        List<U> list = mapList.get(key);
        if (list == null) {
            list = new ArrayList<U>();
            mapList.put(key, list);
        }
        list.add(value);
    }

    public static final <T> boolean addToMaxMap(Map<T, Double> map, T key, double value) {
        Double oldValue = map.get(key);
        if (oldValue == null || value > oldValue) {
            map.put(key, value);
            return true;
        }
        return false;
    }

    public static <T, U> void addToMapListUnique(Map<T, List<U>> mapList, T key, List<U> values) {
        List<U> list = mapList.get(key);
        if (list == null) {
            list = new ArrayList<U>(values.size());
            mapList.put(key, list);
        }
        for (U value : values) {
            if (list.contains(value)) continue;
            list.add(value);
        }
    }

    public static <T, U, V extends Collection<U>> void mergeInUnique(Map<T, V> mapList, Map<T, V> from) {
        for (Map.Entry<T, V> entry : from.entrySet()) {
            T key = entry.getKey();
            Collection value = (Collection)entry.getValue();
            Collection originalValue = (Collection)mapList.get(key);
            if (originalValue != null) {
                HashSet originalSet = new HashSet(originalValue);
                for (Object item : value) {
                    if (originalSet.contains(item)) continue;
                    originalValue.add(item);
                }
                continue;
            }
            mapList.put(key, value);
        }
    }

    public static <S, T> List<T> mapToList(Collection<S> entities, Function<S, T> mapper) {
        return entities == null ? null : entities.stream().map(mapper).collect(Collectors.toList());
    }
}

