/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.opentripplanner.util.I18NString;

public class LocalizedStringFormat
implements I18NString,
Serializable {
    private final String format;
    private final I18NString[] values;

    public LocalizedStringFormat(String format, I18NString ... values) {
        this.format = format;
        this.values = values;
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Locale locale) {
        return String.format(this.format, Arrays.stream(this.values).map(i -> i.toString(locale)).toArray(Object[]::new));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedStringFormat that = (LocalizedStringFormat)o;
        return this.format.equals(that.format) && Arrays.equals(this.values, that.values);
    }

    public int hashCode() {
        int result = Objects.hash(this.format);
        result = 31 * result + Arrays.hashCode(this.values);
        return result;
    }
}

