/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.util;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opentripplanner.openstreetmap.model.OSMWithTags;
import org.opentripplanner.util.I18NString;
import org.opentripplanner.util.ResourceBundleSingleton;

public class LocalizedString
implements I18NString,
Serializable {
    private static final Pattern patternMatcher = Pattern.compile("\\{(.*?)\\}");
    private static transient ListMultimap<String, String> key_tag_names = ArrayListMultimap.create();
    private final String key;
    private final String[] params;

    public LocalizedString(String key) {
        this.key = key;
        this.params = null;
    }

    public LocalizedString(String key, String[] params) {
        this.key = key;
        this.params = params;
    }

    public LocalizedString(String key, OSMWithTags way) {
        this.key = key;
        ArrayList<String> lparams = new ArrayList<String>(4);
        List<String> tag_names = this.getTagNames();
        if (tag_names != null) {
            for (String tag_name : tag_names) {
                String param = way.getTag(tag_name);
                if (param != null) {
                    lparams.add(param);
                    continue;
                }
                lparams.add("");
            }
        }
        this.params = lparams.toArray(new String[lparams.size()]);
    }

    private List<String> getTagNames() {
        if (key_tag_names.containsKey((Object)this.key)) {
            return key_tag_names.get((Object)this.key);
        }
        ArrayList<String> tag_names = new ArrayList<String>(4);
        String english_trans = ResourceBundleSingleton.INSTANCE.localize(this.key, Locale.ENGLISH);
        Matcher matcher = patternMatcher.matcher(english_trans);
        while (matcher.find()) {
            String tag_name = matcher.group(1);
            key_tag_names.put((Object)this.key, (Object)tag_name);
            tag_names.add(tag_name);
        }
        return tag_names;
    }

    public boolean equals(Object other) {
        return other instanceof LocalizedString && this.key.equals(((LocalizedString)other).key) && Arrays.equals(this.params, ((LocalizedString)other).params);
    }

    public int hashCode() {
        int result = Objects.hash(this.key);
        result = 31 * result + Arrays.hashCode(this.params);
        return result;
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Locale locale) {
        if (this.key == null) {
            return null;
        }
        String translation = ResourceBundleSingleton.INSTANCE.localize(this.key, locale);
        if (this.params != null) {
            translation = patternMatcher.matcher(translation).replaceAll("%s");
            return String.format(translation, this.params);
        }
        return translation;
    }
}

