/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental.datasources;

import org.opentripplanner.ext.smoovebikerental.SmooveBikeRentalDataSource;
import org.opentripplanner.ext.smoovebikerental.SmooveBikeRentalDataSourceParameters;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsVehicleRentalDataSource;
import org.opentripplanner.updater.vehicle_rental.datasources.params.GbfsVehicleRentalDataSourceParameters;
import org.opentripplanner.updater.vehicle_rental.datasources.params.VehicleRentalDataSourceParameters;

public class VehicleRentalDataSourceFactory {
    public static DataSource<VehicleRentalPlace> create(VehicleRentalDataSourceParameters source) {
        switch (source.getSourceType()) {
            case GBFS: {
                return new GbfsVehicleRentalDataSource((GbfsVehicleRentalDataSourceParameters)source);
            }
            case SMOOVE: {
                return new SmooveBikeRentalDataSource((SmooveBikeRentalDataSourceParameters)source);
            }
        }
        throw new IllegalArgumentException("Unknown vehicle rental source type: " + source.getSourceType());
    }
}

