/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental.datasources;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.entur.gbfs.v2_2.free_bike_status.GBFSFreeBikeStatus;
import org.entur.gbfs.v2_2.station_information.GBFSStationInformation;
import org.entur.gbfs.v2_2.station_status.GBFSStation;
import org.entur.gbfs.v2_2.station_status.GBFSStationStatus;
import org.entur.gbfs.v2_2.system_information.GBFSSystemInformation;
import org.entur.gbfs.v2_2.vehicle_types.GBFSVehicleTypes;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalSystem;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsFeedLoader;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsFreeVehicleStatusMapper;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsStationInformationMapper;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsStationStatusMapper;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsSystemInformationMapper;
import org.opentripplanner.updater.vehicle_rental.datasources.GbfsVehicleTypeMapper;
import org.opentripplanner.updater.vehicle_rental.datasources.params.GbfsVehicleRentalDataSourceParameters;
import org.opentripplanner.util.OTPFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GbfsVehicleRentalDataSource
implements DataSource<VehicleRentalPlace> {
    private static final Logger LOG = LoggerFactory.getLogger(GbfsVehicleRentalDataSource.class);
    private final String url;
    private final String language;
    private final Map<String, String> httpHeaders;
    private final boolean allowKeepingRentedVehicleAtDestination;
    private GbfsFeedLoader loader;

    public GbfsVehicleRentalDataSource(GbfsVehicleRentalDataSourceParameters parameters) {
        this.url = parameters.getUrl();
        this.language = parameters.language();
        this.httpHeaders = parameters.getHttpHeaders();
        this.allowKeepingRentedVehicleAtDestination = parameters.allowKeepingRentedVehicleAtDestination();
    }

    @Override
    public void setup() {
        this.loader = new GbfsFeedLoader(this.url, this.httpHeaders, this.language);
    }

    @Override
    public boolean update() {
        if (this.loader == null) {
            return false;
        }
        return this.loader.update();
    }

    @Override
    public List<VehicleRentalPlace> getUpdates() {
        GBFSFreeBikeStatus freeBikeStatus;
        GBFSSystemInformation systemInformation = this.loader.getFeed(GBFSSystemInformation.class);
        GbfsSystemInformationMapper systemInformationMapper = new GbfsSystemInformationMapper();
        VehicleRentalSystem system = systemInformationMapper.mapSystemInformation(systemInformation.getData());
        Map<String, RentalVehicleType> vehicleTypes = null;
        GBFSVehicleTypes rawVehicleTypes = this.loader.getFeed(GBFSVehicleTypes.class);
        if (rawVehicleTypes != null) {
            GbfsVehicleTypeMapper vehicleTypeMapper = new GbfsVehicleTypeMapper(system.systemId);
            vehicleTypes = rawVehicleTypes.getData().getVehicleTypes().stream().map(vehicleTypeMapper::mapRentalVehicleType).collect(Collectors.toMap(v -> v.id.getId(), Function.identity()));
        }
        LinkedList<VehicleRentalPlace> stations = new LinkedList<VehicleRentalPlace>();
        GBFSStationInformation stationInformation = this.loader.getFeed(GBFSStationInformation.class);
        GBFSStationStatus stationStatus = this.loader.getFeed(GBFSStationStatus.class);
        if (stationInformation != null && stationStatus != null) {
            Map<String, GBFSStation> statusLookup = stationStatus.getData().getStations().stream().collect(Collectors.toMap(GBFSStation::getStationId, Function.identity()));
            GbfsStationStatusMapper stationStatusMapper = new GbfsStationStatusMapper(statusLookup, vehicleTypes);
            GbfsStationInformationMapper stationInformationMapper = new GbfsStationInformationMapper(system, vehicleTypes, this.allowKeepingRentedVehicleAtDestination);
            stations.addAll(stationInformation.getData().getStations().stream().map(stationInformationMapper::mapStationInformation).peek(stationStatusMapper::fillStationStatus).collect(Collectors.toList()));
        }
        if (OTPFeature.FloatingBike.isOn() && (freeBikeStatus = this.loader.getFeed(GBFSFreeBikeStatus.class)) != null) {
            GbfsFreeVehicleStatusMapper freeVehicleStatusMapper = new GbfsFreeVehicleStatusMapper(system, vehicleTypes);
            stations.addAll(freeBikeStatus.getData().getBikes().stream().map(freeVehicleStatusMapper::mapFreeVehicleStatus).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return stations;
    }

    public String toString() {
        return ToStringBuilder.of(GbfsVehicleRentalDataSource.class).addStr("url", this.url).addStr("language", this.language).addBoolIfTrue("allowKeepingRentedVehicleAtDestination", this.allowKeepingRentedVehicleAtDestination).toString();
    }
}

