/*
 * Decompiled with CFR 0.152.
 */
package org.opentripplanner.updater.vehicle_rental;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opentripplanner.graph_builder.linking.DisposableEdgeCollection;
import org.opentripplanner.graph_builder.linking.LinkingDirection;
import org.opentripplanner.graph_builder.linking.VertexLinker;
import org.opentripplanner.model.FeedScopedId;
import org.opentripplanner.model.base.ToStringBuilder;
import org.opentripplanner.routing.core.TraverseMode;
import org.opentripplanner.routing.core.TraverseModeSet;
import org.opentripplanner.routing.edgetype.StreetVehicleRentalLink;
import org.opentripplanner.routing.edgetype.VehicleRentalEdge;
import org.opentripplanner.routing.graph.Graph;
import org.opentripplanner.routing.vehicle_rental.RentalVehicleType;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalPlace;
import org.opentripplanner.routing.vehicle_rental.VehicleRentalStationService;
import org.opentripplanner.routing.vertextype.StreetVertex;
import org.opentripplanner.routing.vertextype.VehicleRentalStationVertex;
import org.opentripplanner.updater.DataSource;
import org.opentripplanner.updater.GraphWriterRunnable;
import org.opentripplanner.updater.PollingGraphUpdater;
import org.opentripplanner.updater.WriteToGraphCallback;
import org.opentripplanner.updater.vehicle_rental.VehicleRentalUpdaterParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VehicleRentalUpdater
extends PollingGraphUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(VehicleRentalUpdater.class);
    private WriteToGraphCallback saveResultOnGraph;
    Map<FeedScopedId, VehicleRentalStationVertex> verticesByStation = new HashMap<FeedScopedId, VehicleRentalStationVertex>();
    Map<FeedScopedId, DisposableEdgeCollection> tempEdgesByStation = new HashMap<FeedScopedId, DisposableEdgeCollection>();
    private final DataSource<VehicleRentalPlace> source;
    private VertexLinker linker;
    private VehicleRentalStationService service;

    public VehicleRentalUpdater(VehicleRentalUpdaterParameters parameters, DataSource<VehicleRentalPlace> source) throws IllegalArgumentException {
        super(parameters);
        LOG.info("Setting up vehicle rental updater.");
        this.source = source;
        if (this.pollingPeriodSeconds <= 0) {
            LOG.info("Creating vehicle-rental updater running once only (non-polling): {}", source);
        } else {
            LOG.info("Creating vehicle-rental updater running every {} seconds: {}", (Object)this.pollingPeriodSeconds, source);
        }
    }

    @Override
    public void setGraphUpdaterManager(WriteToGraphCallback saveResultOnGraph) {
        this.saveResultOnGraph = saveResultOnGraph;
    }

    @Override
    public void setup(Graph graph) {
        this.linker = graph.getLinker();
        this.service = graph.getService(VehicleRentalStationService.class, true);
        this.source.setup();
    }

    @Override
    protected void runPolling() {
        LOG.debug("Updating vehicle rental stations from " + this.source);
        if (!this.source.update()) {
            LOG.debug("No updates");
            return;
        }
        List<VehicleRentalPlace> stations = this.source.getUpdates();
        VehicleRentalGraphWriterRunnable graphWriterRunnable = new VehicleRentalGraphWriterRunnable(stations);
        this.saveResultOnGraph.execute(graphWriterRunnable);
    }

    @Override
    public void teardown() {
    }

    public String toString() {
        return ToStringBuilder.of(VehicleRentalUpdater.class).addObj("source", this.source).toString();
    }

    private class VehicleRentalGraphWriterRunnable
    implements GraphWriterRunnable {
        private final List<VehicleRentalPlace> stations;

        public VehicleRentalGraphWriterRunnable(List<VehicleRentalPlace> stations) {
            this.stations = stations;
        }

        @Override
        public void run(Graph graph) {
            HashSet<FeedScopedId> stationSet = new HashSet<FeedScopedId>();
            for (VehicleRentalPlace station : this.stations) {
                VehicleRentalUpdater.this.service.addVehicleRentalStation(station);
                stationSet.add(station.getId());
                VehicleRentalStationVertex vehicleRentalVertex = VehicleRentalUpdater.this.verticesByStation.get(station.getId());
                if (vehicleRentalVertex == null) {
                    vehicleRentalVertex = new VehicleRentalStationVertex(graph, station);
                    DisposableEdgeCollection tempEdges = VehicleRentalUpdater.this.linker.linkVertexForRealTime(vehicleRentalVertex, new TraverseModeSet(TraverseMode.WALK), LinkingDirection.BOTH_WAYS, (vertex, streetVertex) -> List.of(new StreetVehicleRentalLink((VehicleRentalStationVertex)vertex, (StreetVertex)streetVertex), new StreetVehicleRentalLink((StreetVertex)streetVertex, (VehicleRentalStationVertex)vertex)));
                    if (vehicleRentalVertex.getOutgoing().isEmpty()) {
                        LOG.info("VehicleRentalPlace {} is unlinked", (Object)vehicleRentalVertex);
                    }
                    Set formFactors = Stream.concat(station.getAvailablePickupFormFactors(false).stream(), station.getAvailableDropoffFormFactors(false).stream()).collect(Collectors.toSet());
                    for (RentalVehicleType.FormFactor formFactor : formFactors) {
                        tempEdges.addEdge(new VehicleRentalEdge(vehicleRentalVertex, formFactor));
                    }
                    VehicleRentalUpdater.this.verticesByStation.put(station.getId(), vehicleRentalVertex);
                    VehicleRentalUpdater.this.tempEdgesByStation.put(station.getId(), tempEdges);
                    continue;
                }
                vehicleRentalVertex.setStation(station);
            }
            ArrayList<FeedScopedId> toRemove = new ArrayList<FeedScopedId>();
            for (Map.Entry<FeedScopedId, VehicleRentalStationVertex> entry : VehicleRentalUpdater.this.verticesByStation.entrySet()) {
                FeedScopedId station = entry.getKey();
                if (stationSet.contains(station)) continue;
                toRemove.add(station);
                VehicleRentalUpdater.this.service.removeVehicleRentalStation(station);
            }
            for (FeedScopedId station : toRemove) {
                VehicleRentalUpdater.this.verticesByStation.remove(station);
                VehicleRentalUpdater.this.tempEdgesByStation.get(station).disposeEdges();
                VehicleRentalUpdater.this.tempEdgesByStation.remove(station);
            }
        }
    }
}

